/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ibus.unsell;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetailsDebugInfoAssetData;
import com.gridnine.xtrip.common.midoffice.model.UnsellProductFinanceDetailsDebugInfoAssetData;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class UnsellSaveFinanceDetailsDebugInfoProcessor
extends BaseProcessor {
    public static String getTemporalObjectUid(String bookingUid) {
        return String.format("autorefund-finance-details-debug-info-%s", bookingUid);
    }

    public void process(MessageContext ctx) throws Exception {
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        if (Boolean.TRUE.equals(ctx.getObject((Enum)IBusMidofficeContextKeys.DONT_SAVE_DEBUG_INFO))) {
            return;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        UnsellFinanceDetailsDebugInfoAssetData assetData = new UnsellFinanceDetailsDebugInfoAssetData();
        for (Map.Entry entry : unsellFinanceDetails.getGdsDetails().entrySet()) {
            UnsellProductFinanceDetailsDebugInfoAssetData productData = new UnsellProductFinanceDetailsDebugInfoAssetData();
            productData.getAppliedRules().addAll(((GdsProductRefexFinanceDetails)entry.getValue()).getDebugInfo().getAppliedRules());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream strm = new ObjectOutputStream(baos);
            strm.writeObject(((GdsProductRefexFinanceDetails)entry.getValue()).getDebugInfo().getDebugInfo());
            strm.close();
            productData.setDebugInfo(baos.toByteArray());
            String productUid = (String)entry.getKey();
            BaseProduct product = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCtr.getEntity()));
            if (product != null) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                productData.setProductTitle(handler.generateShortProductName(product));
            }
            assetData.getProducts().put(entry.getKey(), (Object)productData);
        }
        TemporalObject obj = new TemporalObject();
        obj.setExpired(new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
        obj.setReference(bfCtr.toReference());
        obj.setTag("refex-debug-data");
        obj.setUid(UnsellSaveFinanceDetailsDebugInfoProcessor.getTemporalObjectUid(bfCtr.getUid()));
        obj.setData(XSUtil.toByteArray((XSSerializable)assetData));
        AssetsStorage.get().save((BaseAsset)obj);
    }
}

