/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.mail;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class MailServiceTest
extends TestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSend() throws Exception {
        MailSender service = new MailSender();
        MailServerSettings fakeMailServerSettings = new MailServerSettings();
        fakeMailServerSettings.setMailServerParameters(new MailServerParameters());
        fakeMailServerSettings.getMailServerParameters().setHost("10.0.0.15");
        fakeMailServerSettings.setAdminAddress("dmitry.olshansky@gridnine.com");
        fakeMailServerSettings.setDefaultFrom("support@gridnine.com");
        EntityContainer container = EntityContainer.create((BaseEntity)fakeMailServerSettings, (String)UniqueSettingsRegistry.get().getUidByClassName(MailServerSettings.class.getName()));
        EntityStorage.get().save(container, true);
        service.configure();
        MailDocument doc = new MailDocument();
        doc.setFrom(service.getDefaultFromAddress());
        doc.getTo().add(service.getAdminAddress());
        doc.setSubject("Test from Midoffice - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430");
        MailPart body = new MailPart();
        body.setContentType(ContentType.TEXT);
        body.setName("test.txt");
        body.setData("test - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430".getBytes("utf-8"));
        doc.setBody(body);
        MailPart att = new MailPart();
        att.setContentType(ContentType.JPEG);
        att.setName("test image.jpg");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("test.jpg");){
            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
        }
        att.setData(out.toByteArray());
        doc.getAttachments().add(att);
        service.send(doc);
        byte[] messageData = service.getMailData(doc);
        this.log.debug("message sent:\r\n" + new String(messageData, "utf-8"));
    }
}

