/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.nbrb;

import com.google.common.primitives.Ints;
import com.gridnine.bof.midoffice.cbrrate.CbrRateTask;
import com.gridnine.bof.midoffice.nbrb.ExchangeRateInfo;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NbrbRateTask
extends BaseScheduledTask {
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");

    protected void doJob() throws Exception {
        String dateAsString = this.getParameter("date", this.DATE_FORMAT.format(this.getCurrentDate()));
        try {
            this.DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException exception) {
            this.log.error(String.format("Can't parse date '%s', will use current date instead.", dateAsString));
            dateAsString = this.DATE_FORMAT.format(this.getCurrentDate());
        }
        String urlTxt = this.composeUrlTxt(dateAsString);
        String txt = this.readContent(urlTxt);
        if (TextUtil.isBlank((String)txt)) {
            return;
        }
        int idx = txt.indexOf(60);
        if (idx == -1) {
            this.log.error("unexpected content found at  " + urlTxt + ":\n" + txt);
            return;
        }
        txt = txt.substring(idx);
        List<ExchangeRateInfo> exchangeRates = this.extractExchangeRateInfos(txt);
        ExchangeRateInfo roubleExchangeRate = null;
        for (int i = 0; i < exchangeRates.size() && roubleExchangeRate == null; ++i) {
            ExchangeRateInfo curExchangeRate = exchangeRates.get(i);
            if (!"RUB".equals(curExchangeRate.getCharCode())) continue;
            roubleExchangeRate = curExchangeRate;
        }
        if (roubleExchangeRate != null) {
            BigDecimal dividend = BigDecimal.valueOf(roubleExchangeRate.getScale());
            BigDecimal result = dividend.divide(roubleExchangeRate.getRate(), 15, 4);
            CbrRateTask.updateCurrencyRate(this.DATE_FORMAT.parse(dateAsString), "BYR", result, CurrencyRateType.NBRB, this.log);
        }
    }

    protected String composeUrlTxt(String dateAsString) {
        return String.format("http://www.nbrb.by/Services/XmlExRates.aspx?ondate=%s", dateAsString);
    }

    protected List<ExchangeRateInfo> extractExchangeRateInfos(String txt) {
        ArrayList<ExchangeRateInfo> result = new ArrayList<ExchangeRateInfo>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(txt)));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//Currency");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            XPathExpression numCodeXPathExpr = this.createXPathExpression(xpath, "NumCode/text()");
            XPathExpression charCodeXPathExpr = this.createXPathExpression(xpath, "CharCode/text()");
            XPathExpression scaleXPathExpr = this.createXPathExpression(xpath, "Scale/text()");
            XPathExpression rateXPathExpr = this.createXPathExpression(xpath, "Rate/text()");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                String numCodeTxt = this.extractString(numCodeXPathExpr, item);
                String charCode = this.extractString(charCodeXPathExpr, item);
                String scaleTxt = this.extractString(scaleXPathExpr, item);
                String rateTxt = this.extractString(rateXPathExpr, item);
                ExchangeRateInfo rateInfo = new ExchangeRateInfo(numCodeTxt, charCode, Ints.tryParse((String)scaleTxt), new BigDecimal(rateTxt));
                result.add(rateInfo);
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
            this.log.error("", (Throwable)exception);
        }
        return result;
    }

    protected String extractString(XPathExpression numCodeXPathExpr, Node item) throws XPathExpressionException {
        return (String)numCodeXPathExpr.evaluate(item, XPathConstants.STRING);
    }

    protected XPathExpression createXPathExpression(XPath xpath, String expr) throws XPathExpressionException {
        return xpath.compile(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readContent(String urlAsString) {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = null;
        InputStream inputStream = null;
        try {
            String inputLine;
            URL url = new URL(urlAsString);
            inputStream = url.openStream();
            reader = new BufferedReader(this.createInputStreamReader(inputStream));
            while ((inputLine = reader.readLine()) != null) {
                content.append(inputLine);
            }
        }
        catch (IOException exception) {
            try {
                this.log.error("", (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)inputStream);
        return content.toString();
    }

    protected InputStreamReader createInputStreamReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    protected Date getCurrentDate() {
        return new Date();
    }
}

