/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.nbrk;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class NbrkRateTask
extends BaseScheduledTask {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private String url;
    private final Set<String> currencyCodes = new HashSet<String>();

    public void configure(Properties config) throws Exception {
        this.url = config.getProperty("url");
        if (TextUtil.isBlank((String)this.url)) {
            this.log.info("nbrk service url is not defined");
            return;
        }
        String currencies = config.getProperty("currencies");
        if (!TextUtil.isBlank((String)currencies)) {
            for (String item : currencies.split(",")) {
                if (!TextUtil.nonBlank((String)item)) continue;
                this.currencyCodes.add(item.trim().toUpperCase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() throws Exception {
        try {
            long start = System.currentTimeMillis();
            URL serviceUrl = new URL(this.url);
            URLConnection urlConnection = serviceUrl.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-Type", "text/html; charset=windows-1251");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataInputStream in = new DataInputStream(urlConnection.getInputStream());){
                IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
            }
            byte[] byteArray = out.toByteArray();
            this.log.trace(String.format("NBRK request: GET %s;\r\n response: {%s}\r\n;timing = %s msec", this.url, new String(byteArray, StandardCharsets.UTF_8), System.currentTimeMillis() - start));
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byteArray)).getDocumentElement();
            for (Element elm : XmlUtil.getElements((Element)root, (String)"channel/item")) {
                String currencyCode = XHelper.readString((Element)elm, (String)"title");
                if (!this.currencyCodes.isEmpty() && !this.currencyCodes.contains(currencyCode)) {
                    this.log.debug("skipping update of rate for " + currencyCode);
                    continue;
                }
                this.updateCurrencyRate(DATE_FORMAT.parse(XHelper.readString((Element)elm, (String)"pubDate")), currencyCode, BigDecimal.valueOf(Double.parseDouble(XHelper.readString((Element)elm, (String)"description"))).divide(BigDecimal.valueOf(Integer.parseInt(XHelper.readString((Element)elm, (String)"quant"))), 20, RoundingMode.HALF_UP), CurrencyRateType.NBRK);
            }
        }
        catch (Exception e) {
            this.log.error("failed updating currency rates", (Throwable)e);
            String message = "An error has occurred while updating NBRK exchange rates.\r\nDetails:\r\n" + TextUtil.getExceptionStackTrace((Throwable)e) + "\r\n" + MidofficeHelper.getStandardPlainTextFooter("\r\n");
            MidofficeHelper.sendSystemEmail("NBRK exchange rates update failure", message);
        }
    }

    public void updateCurrencyRate(Date date, String currencyCode, BigDecimal rate, CurrencyRateType currencyRateType) {
        try {
            CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"KZT", (String)currencyCode, (Date)date, (CurrencyRateType)currencyRateType, (TariffType)TariffType.REGULAR, null, null);
            if (currencyRate != null && currencyRate.getType() == currencyRateType && currencyRate.getDate() != null && rate.compareTo(BigDecimal.valueOf(currencyRate.getRate())) == 0) {
                this.log.debug(String.format("currency rate not changed for %s, value=%s", currencyCode, rate));
                return;
            }
            if (currencyRate != null && currencyRate.getType() == currencyRateType && currencyRate.getDate() != null && MiscUtil.compare((Date)date, (Date)MiscUtil.clearTime((Date)currencyRate.getDate())) == 0) {
                DictionaryStorage.get().delete((BaseDictionary)currencyRate);
                this.log.debug(String.format("deleted currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
            }
            this.saveCurrency(date, currencyCode, rate);
        }
        catch (Exception e) {
            this.log.warn("failed updating currency rate for code " + currencyCode, (Throwable)e);
            String message = "An error has occurred while updating NBRK exchange rate for code " + currencyCode + ".\r\nDetails:\r\n" + TextUtil.getExceptionStackTrace((Throwable)e) + "\r\n" + MidofficeHelper.getStandardPlainTextFooter("\r\n");
            MidofficeHelper.sendSystemEmail("NBRK exchange rate update for code " + currencyCode + " failure", message);
        }
    }

    private void saveCurrency(Date date, String currencyCode, BigDecimal rate) {
        CurrencyRate currencyRate = new CurrencyRate();
        currencyRate.setCurrency(currencyCode);
        currencyRate.setRate(rate.doubleValue());
        currencyRate.setTariffType(TariffType.REGULAR);
        currencyRate.setType(CurrencyRateType.NBRK);
        currencyRate.setBaseCurrency("KZT");
        currencyRate.setDate(date);
        LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)currencyRate);
        this.log.debug(String.format("added currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
    }
}

