/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.paymentfee;

import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentFeeConfig {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private Double defaultPercent;
    private CalculationType defaultType = CalculationType.FEE_ON_TRANSACTION;
    private final Map<String, Map<PaymentType, Double>> feesMap = new HashMap<String, Map<PaymentType, Double>>();
    private final Map<String, Double> defaultFees = new HashMap<String, Double>();
    private final Map<String, Map<PaymentType, CalculationType>> typesMap = new HashMap<String, Map<PaymentType, CalculationType>>();
    private final Map<String, CalculationType> defaultTypes = new HashMap<String, CalculationType>();

    public PaymentFeeConfig(Properties configuration) {
        if (configuration == null) {
            this.log.warn("properties is undefined, default percent is set to zero");
            this.defaultPercent = 0.0;
            return;
        }
        String percent = configuration.getProperty("value.default");
        if (TextUtil.isBlank((String)percent)) {
            this.log.error("property \"value.default\" is undefined, fee percent is set to zero");
            this.defaultPercent = 0.0;
            return;
        }
        try {
            this.defaultPercent = new Double(percent.trim());
            this.log.info(String.format("fee percent is set to %s%%", this.defaultPercent));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to parse percent from \"%s\", it is set to zero", percent));
            this.defaultPercent = 0.0;
            return;
        }
        String type = configuration.getProperty("type.default");
        this.defaultType = "price".equals(type) ? CalculationType.FEE_ON_PRICE : CalculationType.FEE_ON_TRANSACTION;
        this.log.info(String.format("calculation type is %s (config value is %s)", new Object[]{this.defaultType, type}));
        String productTypes = configuration.getProperty("productTypes");
        if (!TextUtil.isBlank((String)productTypes)) {
            for (String productType : productTypes.split(",")) {
                if (TextUtil.isBlank((String)productType)) continue;
                this.initialize(configuration, productType);
            }
        }
    }

    public BigDecimal getFee(BigDecimal price, Class<?> productType, PaymentType paymentType) {
        Double percent = this.getFeePercent(productType, paymentType);
        CalculationType calculationType = this.getCalculationType(productType, paymentType);
        BigDecimal feeValue = calculationType == CalculationType.FEE_ON_PRICE ? BigDecimal.valueOf(price.doubleValue() * percent / 100.0) : BigDecimal.valueOf(price.doubleValue() * percent / (100.0 - percent));
        feeValue = feeValue.divide(BigDecimal.ONE, 4, RoundingMode.HALF_UP).divide(BigDecimal.ONE, 0, RoundingMode.UP);
        return feeValue;
    }

    private Double getFeePercent(Class<?> productType, PaymentType paymentType) {
        Double result;
        Double result2;
        Map<PaymentType, Double> map;
        if (productType == null && paymentType == null) {
            return this.defaultPercent;
        }
        if (productType != null && paymentType != null && (map = this.feesMap.get(MiscUtil.getSimpleClassName(productType))) != null && (result2 = map.get(paymentType)) != null) {
            return result2;
        }
        if (productType != null && (result = this.defaultFees.get(MiscUtil.getSimpleClassName(productType))) != null) {
            return result;
        }
        return this.defaultPercent;
    }

    private CalculationType getCalculationType(Class<?> productType, PaymentType paymentType) {
        CalculationType result;
        CalculationType result2;
        Map<PaymentType, CalculationType> map;
        if (productType == null && paymentType == null) {
            return this.defaultType;
        }
        if (productType != null && paymentType != null && (map = this.typesMap.get(MiscUtil.getSimpleClassName(productType))) != null && (result2 = map.get(paymentType)) != null) {
            return result2;
        }
        if (productType != null && (result = this.defaultTypes.get(MiscUtil.getSimpleClassName(productType))) != null) {
            return result;
        }
        return this.defaultType;
    }

    private void initialize(Properties configuration, String productType) {
        this.initializeDefault(configuration, productType);
        for (PaymentType paymentType : PaymentType.values()) {
            this.initializeFee(configuration, productType, paymentType);
            this.initializeTypes(configuration, productType, paymentType);
        }
    }

    private void initializeTypes(Properties configuration, String productType, PaymentType paymentType) {
        String value = configuration.getProperty(String.format("type.%s.%s", productType, paymentType.name()));
        if (TextUtil.isBlank((String)value)) {
            this.log.warn(String.format("there is no calculation type defined for product %s for payment type %s", productType, paymentType.name()));
            return;
        }
        Map map = this.typesMap.computeIfAbsent(productType, k -> new HashMap());
        map.put(paymentType, "price".equals(value) ? CalculationType.FEE_ON_PRICE : CalculationType.FEE_ON_TRANSACTION);
        this.log.info(String.format("calculation type for product %s for payment type %s was set %s", productType, paymentType, map.get(paymentType)));
    }

    private void initializeFee(Properties configuration, String productType, PaymentType paymentType) {
        String percent = configuration.getProperty(String.format("value.%s.%s", productType, paymentType.name()));
        if (TextUtil.isBlank((String)percent)) {
            this.log.warn(String.format("there is no payment fee defined for product %s payment type %s", productType, paymentType.name()));
            return;
        }
        try {
            Double value = new Double(percent.trim());
            Map fees = this.feesMap.computeIfAbsent(productType, k -> new HashMap());
            fees.put(paymentType, value);
            this.log.info(String.format("fee for product %s and payment type %s was set %s%%", productType, paymentType, value));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to parse fee for product %s for payment type %s from \"%s\"", productType, paymentType, percent), (Throwable)e);
        }
    }

    private void initializeDefault(Properties configuration, String productType) {
        this.initializeDefaultTypes(configuration, productType);
        this.initializeDefaultFees(configuration, productType);
    }

    private void initializeDefaultFees(Properties configuration, String productType) {
        String percent = configuration.getProperty(String.format("value.%s.default", productType));
        try {
            if (TextUtil.isBlank((String)percent)) {
                this.log.warn(String.format("there is no default payment fee defined for product %s", productType));
                return;
            }
            Double value = new Double(percent.trim());
            this.defaultFees.put(productType, value);
            this.log.info(String.format("default fee for product %s was set %s%%", productType, value));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to parse default fee for product %s from \"%s\"", productType, percent), (Throwable)e);
        }
    }

    private void initializeDefaultTypes(Properties configuration, String productType) {
        String percent = configuration.getProperty(String.format("type.%s.default", productType));
        if (TextUtil.isBlank((String)percent)) {
            this.log.warn(String.format("there is no default calculation type defined for product %s", productType));
            return;
        }
        this.defaultTypes.put(productType, "price".equals(percent) ? CalculationType.FEE_ON_PRICE : CalculationType.FEE_ON_TRANSACTION);
        this.log.info(String.format("default calculation type for product %s was set %s", new Object[]{productType, this.defaultTypes.get(productType)}));
    }

    private static enum CalculationType {
        FEE_ON_PRICE,
        FEE_ON_TRANSACTION;

    }
}

