/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ssl;

import com.gridnine.bof.midoffice.ssl.KeyManager;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class DatabaseSecurityHelper {
    private static DatabaseSecurityHelper m_instance = null;

    public static synchronized DatabaseSecurityHelper getInstance() {
        if (m_instance == null) {
            m_instance = new DatabaseSecurityHelper();
        }
        return m_instance;
    }

    private DatabaseSecurityHelper() {
    }

    public byte[] sign(String alias, String algorithm, byte[] data) throws Exception {
        KeyPair keyPair = KeyManager.getInstance().getKeyPair(alias);
        if (keyPair == null) {
            throw new Exception(String.format("No key pair found for alias \"%s\". See \"key-generation-procedure.txt\"", alias));
        }
        PrivateKey privateKey = keyPair.getPrivate();
        Signature sig = Signature.getInstance(algorithm);
        sig.initSign(privateKey);
        sig.update(data);
        return sig.sign();
    }

    public byte[] decryptData(String alias, String algorithm, byte[] data) throws Exception {
        KeyPair keyPair = KeyManager.getInstance().getKeyPair(alias);
        PrivateKey privateKey = keyPair.getPrivate();
        Cipher enc = Cipher.getInstance(algorithm);
        enc.init(2, privateKey);
        return enc.doFinal(data);
    }

    public static byte[] encryptData(byte[] publicKey, String algorithm, byte[] data) throws GeneralSecurityException {
        Cipher enc = Cipher.getInstance(algorithm);
        enc.init(1, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey)));
        return enc.doFinal(data);
    }
}

