/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ssl;

import com.gridnine.xtrip.common.midoffice.KeyPairEntry;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyManager {
    private static KeyManager instance;

    private KeyManager() {
    }

    public static KeyManager getInstance() {
        if (instance == null) {
            instance = new KeyManager();
        }
        return instance;
    }

    public KeyPair getKeyPair(String alias) {
        AssetsStorage as = AssetsStorage.get();
        KeyPairEntry entry = (KeyPairEntry)as.find(KeyPairEntry.class, KeyPairEntry.Property.alias.name(), (Object)alias);
        return entry != null ? entry.getKeyPair() : null;
    }

    public List<String> listAliases() {
        AssetsStorage as = AssetsStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(KeyPairEntry.Property.alias.name(), SortOrder.ASC);
        List data = as.search(KeyPairEntry.class, query).getData();
        ArrayList<String> aliases = new ArrayList<String>(data.size());
        for (KeyPairEntry entry : data) {
            aliases.add(entry.getAlias());
        }
        return aliases;
    }

    public Map<String, KeyPair> getKeyPairMap() {
        AssetsStorage as = AssetsStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(KeyPairEntry.Property.alias.name(), SortOrder.ASC);
        List data = as.search(KeyPairEntry.class, query).getData();
        HashMap<String, KeyPair> result = new HashMap<String, KeyPair>();
        for (KeyPairEntry entry : data) {
            result.put(entry.getAlias(), entry.getKeyPair());
        }
        return result;
    }

    public KeyPair generate(String alias, String alg, int keysize) throws Exception {
        if (TextUtil.isBlank((String)alias)) {
            throw new IllegalArgumentException("Alias unspecified!");
        }
        if (this.exists(alias)) {
            throw new IllegalArgumentException("Alias already exists!");
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(alg);
        keyGen.initialize(keysize);
        KeyPair keyPair = keyGen.genKeyPair();
        KeyPairEntry entry = new KeyPairEntry();
        entry.setAlias(alias);
        entry.setKeyPair(keyPair);
        entry = (KeyPairEntry)AssetsStorage.get().save((BaseAsset)entry);
        return entry.getKeyPair();
    }

    public boolean exists(String alias) {
        KeyPair pair = this.getKeyPair(alias);
        return pair != null;
    }

    public void delete(String alias) {
        AssetsStorage as = AssetsStorage.get();
        KeyPairEntry entry = (KeyPairEntry)as.find(KeyPairEntry.class, KeyPairEntry.Property.alias.name(), (Object)alias);
        as.delete((BaseAsset)entry);
    }

    public KeyPairEntry add(String alias, KeyPair pair) {
        KeyPairEntry entry = new KeyPairEntry();
        entry.setKeyPair(pair);
        entry.setAlias(alias);
        return (KeyPairEntry)AssetsStorage.get().save((BaseAsset)entry);
    }

    public void deleteAll() {
        AssetsStorage as = AssetsStorage.get();
        SearchQuery query = new SearchQuery();
        List data = as.search(KeyPairEntry.class, query).getData();
        for (KeyPairEntry entry : data) {
            as.delete((BaseAsset)entry);
        }
    }

    public void copy(String aliasFrom, String aliasTo) {
        KeyPair kpair = this.getKeyPair(aliasFrom);
        if (kpair != null && !this.exists(aliasTo)) {
            this.add(aliasTo, kpair);
        }
    }
}

