/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.ssl;

import com.gridnine.xtrip.common.midoffice.KeyPairEntry;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Index;

@Entity
public class KeyPairEntryData
extends BaseAssetData<KeyPairEntry> {
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="KeyPairEntryData_modified")
    private Date modified;
    @Index(name="KeyPairEntryData_alias")
    private String alias;
    @Lob
    @Column(length=0x40000000)
    private byte[] keyPairData;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public KeyPairEntry toAsset(Set<String> preferredProperties) throws Exception {
        KeyPairEntry asset = new KeyPairEntry();
        asset.setUid(this.getUid());
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains(KeyPairEntry.Property.alias.name())) {
            asset.setAlias(this.alias);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(KeyPairEntry.Property.keyPairData.name())) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.keyPairData);
            ObjectInputStream ois = new ObjectInputStream(bais);
            asset.setKeyPair((KeyPair)ois.readObject());
        }
        return asset;
    }

    public void fromAsset(KeyPairEntry asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.alias = asset.getAlias();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(asset.getKeyPair());
        this.keyPairData = baos.toByteArray();
    }
}

