/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.tpt;

import com.gridnine.bof.midoffice.tpt.Template;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class TPTEngine
implements Serializable {
    private static final long serialVersionUID = -3048341284501896162L;
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private final Resolver resolver;

    public TPTEngine(Resolver r) {
        this.resolver = r;
    }

    public void render(String template, Map<String, Object> ctx, Appendable out) throws IOException {
        this.getTemplate(template).render(ctx, out);
    }

    private synchronized Template getTemplate(String template) throws IOException {
        Template result = this.templates.get(template);
        if (result == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream strm = this.resolver.resolve(template);){
                IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
            }
            result = new Template(this, new String(baos.toByteArray(), StandardCharsets.UTF_8));
            this.templates.put(template, result);
        }
        return result;
    }

    public static interface Resolver {
        public InputStream resolve(String var1);
    }
}

