/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.tpt;

import com.gridnine.bof.midoffice.tpt.Block;
import com.gridnine.bof.midoffice.tpt.IfBlock;
import com.gridnine.bof.midoffice.tpt.IfNotBlock;
import com.gridnine.bof.midoffice.tpt.IncludeBlock;
import com.gridnine.bof.midoffice.tpt.ParameterBlock;
import com.gridnine.bof.midoffice.tpt.RepeatBlock;
import com.gridnine.bof.midoffice.tpt.SubBlock;
import com.gridnine.bof.midoffice.tpt.TPTEngine;
import com.gridnine.bof.midoffice.tpt.TextBlock;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class Template
implements Serializable {
    private static final long serialVersionUID = -6613262483851829516L;
    private final List<Block> blocks = new ArrayList<Block>();
    private final TPTEngine engine;

    Template(TPTEngine eng, String string) {
        this.engine = eng;
        int p = 0;
        while (p < string.length()) {
            int i2;
            int i = string.indexOf(36, p);
            if (i == -1 || i == string.length() - 1) {
                this.blocks.add(new TextBlock(string.substring(p)));
                return;
            }
            if (string.charAt(i + 1) == '{' && (i2 = string.indexOf(125, i)) != -1) {
                this.blocks.add(new TextBlock(string.substring(p, i)));
                this.blocks.add(new ParameterBlock(string.substring(i + 2, i2)));
                p = i2 + 1;
                continue;
            }
            if (string.charAt(i + 1) == '[' && (i2 = string.indexOf(93, i)) != -1) {
                int i3;
                String substr = string.substring(i + 2, i2);
                if (substr.startsWith("repeat:") && (i3 = this.findBlockEnd(string, i2, "repeat")) != -1) {
                    this.blocks.add(new TextBlock(string.substring(p, i)));
                    this.blocks.add(new RepeatBlock(substr.substring(7), new Template(this.engine, string.substring(i2 + 1, i3))));
                    p = i3 + 6 + 3;
                    continue;
                }
                if (substr.startsWith("sub:") && (i3 = this.findBlockEnd(string, i2, "sub")) != -1) {
                    this.blocks.add(new TextBlock(string.substring(p, i)));
                    this.blocks.add(new SubBlock(substr.substring(4), new Template(this.engine, string.substring(i2 + 1, i3))));
                    p = i3 + 3 + 3;
                    continue;
                }
                if (substr.startsWith("if:") && (i3 = this.findBlockEnd(string, i2, "if")) != -1) {
                    this.blocks.add(new TextBlock(string.substring(p, i)));
                    this.blocks.add(new IfBlock(substr.substring(3), new Template(this.engine, string.substring(i2 + 1, i3))));
                    p = i3 + 2 + 3;
                    continue;
                }
                if (substr.startsWith("ifnot:") && (i3 = this.findBlockEnd(string, i2, "ifnot")) != -1) {
                    this.blocks.add(new TextBlock(string.substring(p, i)));
                    this.blocks.add(new IfNotBlock(substr.substring(6), new Template(this.engine, string.substring(i2 + 1, i3))));
                    p = i3 + 5 + 3;
                    continue;
                }
                if (substr.startsWith("include:")) {
                    this.blocks.add(new TextBlock(string.substring(p, i)));
                    this.blocks.add(new IncludeBlock(this.engine, substr.substring(8)));
                    p = i2 + 1;
                    continue;
                }
            }
            this.blocks.add(new TextBlock(string.substring(p, i + 1)));
            p = i + 1;
        }
    }

    private int findBlockEnd(String str, int start, String type) {
        int p = start;
        int count = 0;
        while (p < str.length()) {
            int i = str.indexOf("$[" + type, p);
            if (i == -1) {
                return -1;
            }
            char ch = str.charAt(i + type.length() + 2);
            if (ch == ':') {
                ++count;
            } else if (ch == ']') {
                if (count == 0) {
                    return i;
                }
                --count;
            }
            p = i + 3 + type.length();
        }
        return -1;
    }

    void render(Map<String, Object> ctx, Appendable out) throws IOException {
        for (Block block : this.blocks) {
            block.render(ctx, out);
        }
    }
}

