/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.trace;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTraceItem
implements TraceItem {
    private static Logger log = LoggerFactory.getLogger(DocumentTraceItem.class);
    private final String fileName;
    private final Collection<Document> documents;

    public DocumentTraceItem(String fileName, Collection<Document> document) {
        this.fileName = fileName;
        this.documents = document;
    }

    @Override
    public String getId() {
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream strm) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(strm));){
            writer.writeStartDocument();
            writer.writeStartElement("documents");
            writer.writeAttribute("date", sdf.format(new Date()));
            for (Document document : this.documents) {
                this.writeDocument(writer, document);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            log.error("stream exception", (Throwable)e);
            throw Xeption.forDeveloper((String)"xmlstream exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void writeDocument(XMLStreamWriter writer, Document document) throws XMLStreamException {
        writer.writeStartElement("document");
        writer.writeAttribute("name", MiscUtil.guarded((String)document.getName()));
        writer.writeAttribute("title", MiscUtil.guarded((String)document.getTitle()));
        writer.writeCData(new String(document.getContent()));
        writer.writeEndElement();
    }
}

