/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.trace;

import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesLimitPolicy
implements TraceDataPolicy {
    private static final long serialVersionUID = -2397862193701381413L;
    private final int limit;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public FilesLimitPolicy(int filesCountLimit) {
        this.limit = filesCountLimit;
    }

    @Override
    public File apply(File folder) {
        if (this.limit <= 0 || folder == null) {
            return folder;
        }
        List<File> files = Arrays.asList(folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        }));
        if (files.size() <= this.limit) {
            return folder;
        }
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long time2;
                long time1 = o1.lastModified();
                return time1 < (time2 = o2.lastModified()) ? -1 : (time1 == time2 ? 0 : 1);
            }
        });
        int count = 0;
        for (File file : files) {
            if (file.delete()) {
                ++count;
                this.log.debug("deleted trace file " + file);
            } else {
                this.log.debug("failed deleting trace file " + file);
            }
            if (files.size() > count + this.limit) continue;
            break;
        }
        return folder;
    }
}

