/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.bof.midoffice.trace;

import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracer {
    private static int lastId = 0;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private TracerConfiguration configuration;
    private Timer timer;
    private final List<QueueItem> queue = new LinkedList<QueueItem>();
    private boolean processing;
    private final PropertyChangeListener configurationChangeListener = evt -> this.configurationChanged();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Tracer tracer = this;
        synchronized (tracer) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.processQueue();
        this.log.debug("disposed");
    }

    public TracerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TracerConfiguration value) {
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(this.configurationChangeListener);
            this.configuration = null;
        }
        this.configuration = value;
        if (this.configuration != null) {
            this.configuration.addPropertyChangeListener(this.configurationChangeListener);
        }
        this.configurationChanged();
    }

    synchronized void configurationChanged() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.startNewTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(TraceItem ... items) {
        QueueItem queueItem = new QueueItem(items);
        List<QueueItem> list = this.queue;
        synchronized (list) {
            this.queue.add(queueItem);
        }
    }

    private void startNewTimer() {
        if (this.configuration == null || this.configuration.getFolder() == null) {
            return;
        }
        if (!this.configuration.getFolder().isDirectory() && !this.configuration.getFolder().mkdirs()) {
            this.log.warn(String.format("failed creating folder %s, tracing disabled", this.configuration.getFolder()));
            return;
        }
        this.timer = new Timer("log-tracer-" + lastId++, true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TraceDataPolicy policy = Tracer.this.getConfiguration().getPolicy();
                if (Tracer.this.processQueue() > 0 && policy != null) {
                    policy.apply(Tracer.this.getConfiguration().getFolder());
                }
            }
        }, (long)this.configuration.getInterval() * 1000L, (long)this.configuration.getInterval() * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processQueue() {
        if (this.processing) {
            return 0;
        }
        this.processing = true;
        try {
            ArrayList<QueueItem> list;
            List<QueueItem> list2 = this.queue;
            synchronized (list2) {
                list = new ArrayList<QueueItem>(this.queue);
                this.queue.clear();
            }
            if (list.isEmpty()) {
                int n = 0;
                return n;
            }
            File folder = this.getConfiguration().getPolicy() != null ? this.getConfiguration().getPolicy().apply(this.configuration.getFolder()) : this.configuration.getFolder();
            int result = 0;
            for (QueueItem queueItem : list) {
                result += queueItem.trace(folder);
            }
            int n = result;
            return n;
        }
        finally {
            this.processing = false;
        }
    }

    private static final class QueueItem {
        private static final Logger log = LoggerFactory.getLogger(Tracer.class);
        private final TraceItem[] traceItems;

        QueueItem(TraceItem ... data) {
            this.traceItems = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int trace(File folder) {
            if (folder == null || this.traceItems == null) {
                return 0;
            }
            int result = 0;
            for (TraceItem item : this.traceItems) {
                if (item == null) continue;
                File file = new File(folder, item.getId());
                try {
                    try (BufferedOutputStream strm = new BufferedOutputStream(new FileOutputStream(file, false));){
                        item.write(strm);
                    }
                    log.debug("item traced to file " + file);
                    ++result;
                }
                catch (Throwable t) {
                    log.error("failed tracing item to file " + file, t);
                }
            }
            return result;
        }
    }
}

