/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.backup;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class BackupTask
extends BaseScheduledTask {
    private String cleanCommand;
    private String serverStopCommand;
    private String serverStartCommand;
    private String vacuumCommand;
    private String copyCommand;
    private String compressCommand;
    private boolean stopOtherTasks;
    private static final String COPY_COMMAND = "copy_command";
    private static final String VACUUM_COMMAND = "vacuum_command";
    private static final String CLEAN_COMMAND = "cleanup_command";
    private static final String COMPRESS_COMMAND = "compress_command";
    private static final String SERVER_STOP_COMMAND = "server_stop_command";
    private static final String SERVER_START_COMMAND = "server_start_command";
    private static final String STOP_OTHER_TASKS = "stop_other_tasks";

    protected void doJob() throws Exception {
        HashSet<String> stoppedTasks = new HashSet<String>();
        try {
            this.stopLongRunningTasks(stoppedTasks);
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmSS").format(new Date());
            this.log.debug("backup-service started");
            if (!TextUtil.isBlank((String)this.cleanCommand)) {
                this.runCommand("clean_command", this.cleanCommand, false);
            }
            if (!TextUtil.isBlank((String)this.vacuumCommand)) {
                this.runCommand(VACUUM_COMMAND, this.vacuumCommand, true);
            }
            if (!TextUtil.isBlank((String)this.serverStopCommand)) {
                this.runCommand(SERVER_STOP_COMMAND, this.serverStopCommand, true);
            }
            if (!TextUtil.isBlank((String)this.copyCommand)) {
                this.runCommand(COPY_COMMAND, this.copyCommand, true);
            }
            if (!TextUtil.isBlank((String)this.serverStartCommand)) {
                this.runCommand(SERVER_START_COMMAND, this.serverStartCommand, true);
            }
            if (!TextUtil.isBlank((String)this.compressCommand)) {
                this.runCommand(COMPRESS_COMMAND, BackupTask.formatCommand(this.compressCommand, timestamp), false);
            }
            this.log.debug("backup-service finished");
        }
        finally {
            this.resumeLonkRunningTasks(stoppedTasks);
        }
    }

    private void resumeLonkRunningTasks(Set<String> tasksUids) {
        for (String item : tasksUids) {
            try {
                ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).resumeTask(item);
                this.log.info(String.format("task with uid %s resumed", item));
            }
            catch (Exception e) {
                this.log.error(String.format("unable to resume task with uid %s", item), (Throwable)e);
            }
        }
    }

    private void stopLongRunningTasks(Set<String> tasksUids) throws Exception {
        if (!this.stopOtherTasks) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)LongRunningTaskInfo.Property.state.name(), (Object)LongRunningTaskInfo.State.RUNNING));
        for (LongRunningTaskInfo data : AssetsStorage.get().search(LongRunningTaskInfo.class, query).getData()) {
            ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(data.getUid());
            tasksUids.add(data.getUid());
            this.log.info(String.format("task %s with uid %s stopped", data.getDescription(), data.getUid()));
        }
    }

    private void runCommand(String name, String command, boolean throwExceptionOnFail) throws Exception {
        this.log.debug(String.format("running %s: %s", name, command));
        Process proc = Runtime.getRuntime().exec(command, null, Environment.getRootFolder());
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        int res = proc.waitFor();
        if (res != 0) {
            this.log.error(String.format("%s returned exit code %s", name, Integer.toString(res)));
            if (throwExceptionOnFail) {
                throw new Exception(String.format("%s returned exit code %s", name, Integer.toString(res)));
            }
        }
    }

    private static String formatCommand(String command, String timestamp) {
        return command.replaceAll("\\{timestamp\\}", timestamp);
    }

    public void configure(Properties config) throws Exception {
        if (config.containsKey(VACUUM_COMMAND)) {
            this.vacuumCommand = BackupTask.resolveScriptPaths(config.getProperty(VACUUM_COMMAND));
        }
        if (config.containsKey(SERVER_STOP_COMMAND)) {
            this.serverStopCommand = BackupTask.resolveScriptPaths(config.getProperty(SERVER_STOP_COMMAND));
        }
        if (config.containsKey(SERVER_START_COMMAND)) {
            this.serverStartCommand = BackupTask.resolveScriptPaths(config.getProperty(SERVER_START_COMMAND));
        }
        if (config.containsKey(COPY_COMMAND)) {
            this.copyCommand = BackupTask.resolveScriptPaths(config.getProperty(COPY_COMMAND));
        }
        if (config.containsKey(CLEAN_COMMAND)) {
            this.cleanCommand = BackupTask.resolveScriptPaths(config.getProperty(CLEAN_COMMAND));
        }
        if (config.containsKey(COMPRESS_COMMAND)) {
            this.compressCommand = BackupTask.resolveScriptPaths(config.getProperty(COMPRESS_COMMAND));
        }
        this.stopOtherTasks = "true".equals(config.get(STOP_OTHER_TASKS));
    }

    private static String resolveScriptPaths(String command) {
        if (command.startsWith("scriptfile:")) {
            File binFolder = new File(Environment.getRootFolder(), "bin");
            File[] files = binFolder.listFiles();
            if (files.length == 1 && files[0].isDirectory()) {
                return Environment.getRootFolder().getAbsolutePath() + File.separator + "bin" + File.separator + files[0].getName() + File.separator + "server" + File.separator + command.substring(11);
            }
            return Environment.getRootFolder().getAbsolutePath() + File.separator + "bin" + File.separator + "server" + File.separator + command.substring(11);
        }
        return command;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    BackupTask.this.log.debug(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                BackupTask.this.log.error("", (Throwable)ioe);
            }
        }
    }
}

