/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadPostgreSQL {
    private static final Logger log = LoggerFactory.getLogger(LoadPostgreSQL.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();

    public static boolean doIt() throws Throwable {
        try {
            LogicalStorage.get().authorizeAsSystem();
            try {
                LoadPostgreSQL.test();
            }
            finally {
                LogicalStorage.reset();
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("Error initialization: " + t.getMessage(), t);
            throw t;
        }
    }

    private static void test() throws Exception {
        EntityContainer<Document> document = LoadPostgreSQL.createDocument();
        LogicalStorage.get().getEntityStorage().save(document, false);
    }

    protected static EntityContainer<Document> createDocument() {
        Document document = new Document();
        document.setContentType(ContentType.TEXT);
        document.setName("Same value " + ID_GENERATOR.incrementAndGet());
        document.setTitle("Load PostgreSQL document");
        document.setContent("Contenet".getBytes(Charset.forName("UTF-8")));
        EntityContainer documentContainer = EntityContainer.create((BaseEntity)document);
        return documentContainer;
    }

    protected static EntityContainer<Organization> createClient() {
        String user = LogicalStorage.get().getUser();
        EntityContainer clientContainer = new EntityContainer(Organization.class);
        clientContainer.setCreatedBy(user);
        clientContainer.setModifiedBy(user);
        Organization profile = (Organization)clientContainer.getEntity();
        L10nStringHelper.setValue((L10nString)profile.getShortName(), (String)"Client", (Locale)Locale.ENGLISH);
        profile.setActive(true);
        profile.setCode("001");
        profile.setRegistrationId("0000000016");
        return clientContainer;
    }

    protected static EntityContainer<BookingFile> createBookingFile(EntityContainer<Organization> client) {
        BookingFile bookingFile = new BookingFile();
        bookingFile.setCustomerProfile(client.toReference());
        Reservation res = new Reservation();
        res.setBookingFile(bookingFile);
        bookingFile.getReservations().add(res);
        bookingFile.setNumber("Same value " + ID_GENERATOR.incrementAndGet());
        EntityContainer ec = EntityContainer.create((BaseEntity)bookingFile);
        return ec;
    }
}

