/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ActionSourceHelper;
import com.gridnine.xtrip.server.model.helpers.Anonymizer;
import com.gridnine.xtrip.server.model.helpers.erasure.ErasureHelper;
import com.gridnine.xtrip.server.model.index.ReceiptStorageProcessing;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;

public class ServerModelPublisher
implements Publisher {
    public void publish() throws Exception {
        this.publishReceiptStorageProcessing();
        this.publishActionSourceHelper();
        this.publishAnonymizer();
        this.publishErasureHelper();
        AclHelper.FULL_ACCESS_TO_FX_ACL_EDITOR = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.FULL_ACCESS_TO_FX_ACL_EDITOR, (boolean)false);
    }

    private void publishReceiptStorageProcessing() {
        Class<ReceiptStorageProcessing> receiptStorageProcessingClass = ReceiptStorageProcessing.class;
        if (!Environment.isPublished(receiptStorageProcessingClass)) {
            Environment.publish(receiptStorageProcessingClass, (Object)new ReceiptStorageProcessing());
        }
    }

    private void publishActionSourceHelper() {
        Class<ActionSourceHelper> actionSourceHelperClass = ActionSourceHelper.class;
        if (!Environment.isPublished(actionSourceHelperClass)) {
            Environment.publish(actionSourceHelperClass, (Object)new ActionSourceHelper());
        }
    }

    private void publishAnonymizer() {
        Anonymizer anonymizer;
        String key = "anonymizer.className";
        String className = System.getProperty(key);
        if (TextUtil.isBlank((String)className)) {
            anonymizer = new Anonymizer();
        } else {
            try {
                Class<?> cls = Class.forName(className);
                anonymizer = (Anonymizer)cls.newInstance();
            }
            catch (Throwable t) {
                throw Xeption.forDeveloper((String)"failed loading class {0} referenced in system property {1}", (Object[])new Object[]{className, key});
            }
        }
        Environment.publish(Anonymizer.class, (Object)anonymizer);
    }

    private void publishErasureHelper() {
        Environment.publish(ErasureHelper.class, (Object)new ErasureHelper());
    }
}

