/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.archive;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.archive.ArchiveBookingsLongRunningTaskConfiguration;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHandlersRegistry;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingRelatedObjectHandler;
import com.gridnine.xtrip.common.model.booking.archive.BookingArchiveSettings;
import com.gridnine.xtrip.common.model.booking.archive.RelatedObjectQueryData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArchiveBookingsLongRunningTask
extends BaseQueryObjectsTask<ArchiveBookingsLongRunningTaskConfiguration> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getEntityType((String)ArchiveBookingsLongRunningTaskConfiguration.class.getName()).getDisplayName(), (Object[])new Object[0]);
    }

    @Override
    public void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.ARCHIVE_SETTINGS));
        SearchResult searchResult = EntityStorage.get().search(BasicSystemSettingsIndex.class, query);
        List data = searchResult.getData();
        if (data.isEmpty()) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ArchiveBookingsLongRunningTask_noArchiveSettings, (Object[])new Object[0]));
            return;
        }
        if (data.size() > 1) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ArchiveBookingsLongRunningTask_fewArchiveSettings, (Object[])new Object[]{Integer.toString(data.size())}));
            return;
        }
        this.logJobConfiguration(callback);
        BookingArchiveSettings settings = (BookingArchiveSettings)EntityStorage.get().resolve(((BasicSystemSettingsIndex)data.get(0)).getSource()).getEntity();
        callback.addEvent(null, this.createParametersDescription(settings));
        int totalCount = this.count(this.createCallback(settings, 0), XHelper.getClass((String)settings.getBookingQueryData().getIndexClassName()));
        this.processObjects(settings.getBookingQueryData().getIndexClassName(), callback, this.createCallback(settings, totalCount));
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ArchiveBookingsLongRunningTask_completeMessage, (Object[])new Object[]{totalCount}));
        callback.taskFinished();
    }

    protected void logJobConfiguration(LongRunningTask.EventsCallback callback) {
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"threadsCount: {0}", (Object[])new Object[]{((ArchiveBookingsLongRunningTaskConfiguration)this.config).getThreadsCount()}));
    }

    private Message createParametersDescription(BookingArchiveSettings settings) {
        String indexClassName = settings.getBookingQueryData().getIndexClassName();
        indexClassName = indexClassName.substring(indexClassName.lastIndexOf(".") + 1);
        SearchQuery query2 = new SearchQuery();
        query2.getCriteria().getCriterions().addAll(settings.getBookingQueryData().getCriterions());
        StringBuilder sb = new StringBuilder();
        for (RelatedObjectQueryData item : settings.getAdditionalEntities()) {
            sb.append(String.format("%s:%s", item.getHandlerId(), item.isInclude() ? "\u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c" : "\u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c"));
        }
        return SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: index: {0}, query: {1}, additional: {2}", (Object[])new Object[]{indexClassName, query2.toString(), sb.toString()});
    }

    protected boolean isBookingFileEmpty(EntityContainer<BookingFile> bookingFile) {
        if (null == bookingFile) {
            return true;
        }
        for (Reservation reservation : ((BookingFile)bookingFile.getEntity()).getReservations()) {
            Iterator iterator = reservation.getProducts().iterator();
            if (!iterator.hasNext()) continue;
            BaseProduct product = (BaseProduct)iterator.next();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(ArchivedBooking booking) {
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            if (!this.isBookingFileEmpty((EntityContainer<BookingFile>)ArchivedBookingHelper.getLastVersion((ArchivedEntity)booking.getBooking()))) {
                EntityContainer archivedBookingCtr = EntityContainer.create((BaseEntity)booking);
                archivedBookingCtr.getVersionInfo().setDataSource("archive-booking-task");
                EntityStorage.get().save(archivedBookingCtr, false, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
            } else {
                this.log.debug("empty booking was skipped");
            }
            ArrayList<ArchivedEntity> entities = new ArrayList<ArchivedEntity>();
            entities.add(booking.getBooking());
            entities.addAll(booking.getAdditionalEntities());
            for (ArchivedEntity entity : entities) {
                EntityStorage.get().delete(ArchivedBookingHelper.getLastVersion((ArchivedEntity)entity), (EntityStorageDeleteParameters)new EntityStorageDeleteParameters().ignoreInterceptors(true));
                for (BaseAsset asset : entity.getAssets()) {
                    AssetsStorage.get().delete(asset, true);
                }
            }
            LogicalStorage.get().endUnitOfWork(ls, true);
            this.log.debug("booking was successfully archived");
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final BookingArchiveSettings settings, final int totalCount) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALLIAS = "uidAllias";
            private static final String ENTITY_TYPE_ALLIAS = "entityTypeAllias";

            @Override
            public int getThreadsCount() {
                return ((ArchiveBookingsLongRunningTaskConfiguration)ArchiveBookingsLongRunningTask.this.config).getThreadsCount();
            }

            @Override
            public int getTotalCount() {
                return totalCount;
            }

            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) throws Exception {
                Class cls = XHelper.getClass((String)settings.getBookingQueryData().getIndexClassName());
                String uid = obj.get(UID_ALLIAS);
                EntityReference item = new EntityReference(uid, BookingFile.class, null);
                ArchiveBookingsLongRunningTask.this.log.debug("analyzing booking " + item);
                SearchQuery query2 = new SearchQuery();
                query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
                ArchiveBookingsLongRunningTask.this.updateQuery((StorageQuery)query2, settings.getBookingQueryData().getCriterions());
                query2.setResultMode(ResultMode.COUNT_ONLY);
                SearchQuery query3 = new SearchQuery();
                query3.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
                query3.setResultMode(ResultMode.COUNT_ONLY);
                if (EntityStorage.get().search(cls, query2).getTotalCount() != EntityStorage.get().search(cls, query3).getTotalCount()) {
                    ArchiveBookingsLongRunningTask.this.log.debug("not all indexes related to this booking satisfy query");
                    return;
                }
                ArchivedBooking booking = ArchiveBookingsLongRunningTask.this.createArchive((EntityReference<BookingFile>)item, settings);
                if (booking == null) {
                    return;
                }
                ArchiveBookingsLongRunningTask.this.save(booking);
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALLIAS);
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                ArrayList<Projection> result = new ArrayList<Projection>();
                result.add(Projection.property((String)"containerUid", (String)UID_ALLIAS));
                result.add(Projection.property((String)"entityType", (String)ENTITY_TYPE_ALLIAS));
                return result;
            }

            @Override
            public String getThreadPrefix() {
                return "archive";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                return settings.getBookingQueryData().getCriterions();
            }
        };
    }

    protected ArchivedBooking createArchive(EntityReference<BookingFile> bookingRef, BookingArchiveSettings settings) throws Exception {
        EntityContainer ctr = EntityStorage.get().resolve(bookingRef);
        if (ctr == null) {
            return null;
        }
        if (!this.isBookingCanBeArchived((EntityContainer<BookingFile>)ctr)) {
            return null;
        }
        HashSet<EntityReference> references = new HashSet<EntityReference>();
        for (ArchivedBookingRelatedObjectHandler handler : ((ArchivedBookingHandlersRegistry)Environment.getPublished(ArchivedBookingHandlersRegistry.class)).getAllHandlers()) {
            Class cls = handler.getIndexClass();
            SearchQuery query = handler.getQuery(ctr);
            if (query == null) continue;
            Integer limit = handler.getLimit();
            if (limit != null) {
                query.setLimit(limit + 1);
            }
            List data = EntityStorage.get().search(cls, query).getData();
            if (limit != null && data.size() > limit) {
                throw Xeption.forDeveloper((String)"booking {0} was not archived as it has >{1} related objects of type {2}", (Object[])new Object[]{bookingRef.getUid(), limit, handler.getIndexClass().getName()});
            }
            for (EntityIndex idx : data) {
                references.add(idx.getSource());
            }
        }
        ArchivedBooking result = new ArchivedBooking();
        ArchivedEntity ett = this.createArchivedEntity(ctr, settings);
        if (ett == null) {
            return null;
        }
        result.setBooking(ett);
        for (EntityReference ref : references) {
            ett = this.createArchivedEntity(ref, settings);
            if (ett == null) continue;
            result.getAdditionalEntities().add(ett);
        }
        return result;
    }

    protected boolean isBookingCanBeArchived(EntityContainer<BookingFile> ctr) {
        return true;
    }

    protected ArchivedEntity createArchivedEntity(EntityReference<?> item, BookingArchiveSettings settings) throws Exception {
        EntityContainer ctr = EntityStorage.get().resolve(item);
        if (ctr == null) {
            this.log.warn("unable to load booking " + item);
            return null;
        }
        item.setCaption(ctr.getEntity().toString());
        return this.createArchivedEntity(ctr, settings);
    }

    protected int getSysLogItemLimit() {
        return 1000;
    }

    protected ArchivedEntity createArchivedEntity(EntityContainer<?> ctr, BookingArchiveSettings settings) throws Exception {
        ArchivedEntity result = new ArchivedEntity();
        ctr.setVersionsCount(1);
        ctr.getVersionInfo().setVersionNumber(0);
        result.getVersions().add(ctr);
        int sysLogItemLimit = this.getSysLogItemLimit();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)ctr.getUid()));
        query.setLimit(sysLogItemLimit + 1);
        List sysLogItems = AssetsStorage.get().search(SysLogItem.class, query).getData();
        if (sysLogItems.size() > sysLogItemLimit) {
            throw Xeption.forDeveloper((String)"booking {0} was not archived as it has >{1} related objects of type {2}", (Object[])new Object[]{ctr.getUid(), sysLogItemLimit, SysLogItem.class.getName()});
        }
        result.getAssets().addAll(sysLogItems);
        return result;
    }
}

