/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.archive;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.booking.archive.UnArchiveBookingTaskConfiguration;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UnArchiveBookingsLongRunningTask
extends BaseQueryObjectsTask<UnArchiveBookingTaskConfiguration> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.UnArchiveBookingsLongRunningTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        int totalCount = this.count(this.createCallback(0), ArchivedProductIndex.class);
        this.processObjects(ArchivedProductIndex.class.getName(), callback, this.createCallback(totalCount));
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.UnArchiveBookingsLongRunningTask_completeMessage, (Object[])new Object[]{totalCount}));
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final int count) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALLIAS = "uidAllias";

            @Override
            public int getThreadsCount() {
                return 1;
            }

            @Override
            public int getTotalCount() {
                return count;
            }

            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) throws Exception {
                String uid = obj.get(UID_ALLIAS);
                BookingDao.unarchiveBookingFile((EntityReference<ArchivedBooking>)new EntityReference(uid, ArchivedBooking.class, null));
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALLIAS);
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                return Collections.singletonList(Projection.property((String)"containerUid", (String)UID_ALLIAS));
            }

            @Override
            public String getThreadPrefix() {
                return "unarchive";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                return ((UnArchiveBookingTaskConfiguration)UnArchiveBookingsLongRunningTask.this.config).getCriterions();
            }
        };
    }
}

