/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.model.assets.DeskEntry;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"owner", "targetType", "targetUid"})})
public class DeskEntryData
extends BaseAssetData<DeskEntry> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="DeskEntryData_modified")
    private Date modified;
    @Column(nullable=false)
    @Index(name="DeskEntryData_owner")
    private String owner;
    @Column(nullable=false)
    private String targetType;
    @Column(nullable=false)
    private String targetUid;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lockedSince;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastActivated;
    @Column(nullable=false)
    private String caption;
    @Column(nullable=false)
    private int initialVersion;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(DeskEntry asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.owner = asset.getOwner();
        this.targetType = asset.getTargetType();
        this.targetUid = asset.getTargetUid();
        this.lockedSince = asset.getLockedSince();
        this.lastActivated = asset.getLastActivated();
        this.caption = asset.getCaption();
        if (this.caption != null && this.caption.length() > 255) {
            this.caption = this.caption.substring(0, 255);
        }
        this.initialVersion = asset.getInitialVersion();
    }

    public DeskEntry toAsset(Set<String> preferredProperties) throws Exception {
        DeskEntry result = new DeskEntry(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("owner")) {
            result.setOwner(this.owner);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("targetType")) {
            result.setTargetType(this.targetType);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("targetUid")) {
            result.setTargetUid(this.targetUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("lockedSince")) {
            result.setLockedSince(MiscUtil.cloneDate((Date)this.lockedSince));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("lastActivated")) {
            result.setLastActivated(MiscUtil.cloneDate((Date)this.lastActivated));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("caption")) {
            result.setCaption(this.caption);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("initialVersion")) {
            result.setInitialVersion(this.initialVersion);
        }
        return result;
    }
}

