/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.ExportReference;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class ExportReferenceData
extends BaseAssetData<ExportReference> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ExportReferenceData_modified")
    private Date modified;
    private String refUid;
    private String refType;
    private String refCaption;
    private Boolean deleted;
    @Lob
    @Column(length=0x40000000)
    private byte[] oldEntity;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(ExportReference asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        EntityReference ref = asset.getRef();
        this.refUid = ref != null ? ref.getUid() : null;
        this.refType = ref != null ? ref.getType().getName() : null;
        this.refCaption = ref != null ? ref.toString() : null;
        EntityContainer oldCtr = asset.getOldEntity();
        this.oldEntity = oldCtr != null ? XSUtil.toByteArray((XSSerializable)oldCtr) : null;
        this.deleted = asset.isDeleted();
    }

    public ExportReference toAsset(Set<String> preferredProperties) throws Exception {
        ExportReference result = new ExportReference(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("ref") || preferredProperties.contains("refUid") && preferredProperties.contains("refType")) {
            result.setRef(this.refUid != null ? new EntityReference(this.refUid, XHelper.getClassForName((String)this.refType), this.refCaption) : null);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("oldEntity")) {
            result.setOldEntity(this.oldEntity != null ? (EntityContainer)XUtil.deserialize((byte[])this.oldEntity) : null);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("deleted")) {
            result.setDeleted(BooleanUtil.nullAsFalse((Boolean)this.deleted));
        }
        return result;
    }
}

