/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.annotations.Index;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Entity
public class LongRunningTaskInfoData
extends BaseAssetData<LongRunningTaskInfo> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="LongRunningTaskInfoData_modified")
    private Date modified;
    @Index(name="LongRunningTaskInfoData_progress")
    private byte progress;
    @Index(name="LongRunningTaskInfoData_taskClassName")
    private String taskClassName;
    @Index(name="LongRunningTaskInfoData_indefinite")
    private boolean indefinite;
    @Index(name="LongRunningTaskInfoData_singleton")
    private boolean singleton;
    @Enumerated(value=EnumType.STRING)
    @Index(name="LongRunningTaskInfoData_state")
    private LongRunningTaskInfo.State state;
    @Lob
    @Column(length=0x40000000)
    private byte[] eventsData;
    @Index(name="LongRunningTaskInfoData_startDate")
    private Date startDate;
    @Index(name="LongRunningTaskInfoData_endDate")
    private Date endDate;
    @Lob
    @Column(length=0x40000000)
    private byte[] descriptionData;
    @Index(name="LongRunningTaskInfoData_createdBy")
    private String createdBy;
    @Index(name="LongRunningTaskInfoData_created")
    private Date created;
    @Index(name="LongRunningTaskInfoData_instance")
    private String instance;
    @Index(name="LongRunningTaskInfoData_serverId")
    private String serverId;
    @Lob
    @Column(length=0x40000000)
    private byte[] configuration;
    @Lob
    @Column(length=0x40000000)
    @Index(name="LongRunningTaskInfoData_aggregatedData")
    private String aggregatedData;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(LongRunningTaskInfo asset) throws Exception {
        this.progress = asset.getProgress();
        this.modified = asset.getModified();
        this.taskClassName = asset.getTaskClassName();
        this.setUid(asset.getUid());
        this.indefinite = asset.isIndefinite();
        this.singleton = asset.isSingleton();
        this.state = asset.getState();
        this.instance = asset.getInstance();
        this.serverId = asset.getServerId();
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset.getEvents(), (OutputStream)strm);
        this.eventsData = strm.toByteArray();
        this.startDate = asset.getStartDate();
        this.endDate = asset.getEndDate();
        this.createdBy = asset.getCreatedBy();
        this.created = asset.getCreated();
        DataAggregator aggregator = new DataAggregator();
        if (asset.getDescription() != null) {
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("object");
            XHelper.writeString((Element)root, (String)"key", (String)asset.getDescription().getKey());
            if (asset.getDescription().getParameters().size() > 0) {
                Element elem = XmlUtil.addElement((Element)root, (String)"parameters");
                for (Object item : asset.getDescription().getParameters()) {
                    XHelper.writeObject((Element)elem, (String)"item", item);
                }
            }
            doc.appendChild(root);
            ByteArrayOutputStream strm2 = new ByteArrayOutputStream();
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm2));
            this.descriptionData = strm2.toByteArray();
            aggregator.aggregate((Object)asset.getDescription().toString());
        } else {
            this.descriptionData = null;
        }
        for (LongRunningTaskInfo.Event ed : asset.getEvents().get()) {
            Message msg = ed.getDescription();
            if (msg == null) continue;
            aggregator.aggregate((Object)LocaleManager.get().getL10nResourceManager().getMessage(msg.getMessage()));
            aggregator.aggregate((Object)msg.getDetails());
        }
        String str = aggregator.toString();
        if (str.length() > 500) {
            str = str.substring(0, 500);
        }
        this.aggregatedData = str;
        if (asset.getConfiguration() != null) {
            try (ByteArrayOutputStream strm3 = new ByteArrayOutputStream();){
                XUtil.serialize((XSerializable)asset.getConfiguration(), (OutputStream)strm3);
                this.configuration = GZIPUtil.gzip((byte[])strm3.toByteArray());
            }
        }
    }

    public LongRunningTaskInfo toAsset(Set<String> preferredProperties) throws Exception {
        LongRunningTaskInfo result = new LongRunningTaskInfo(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("progress")) {
            result.setProgress(this.progress);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("taskClassName")) {
            result.setTaskClassName(this.taskClassName);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("indefinite")) {
            result.setIndefinite(this.indefinite);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("singleton")) {
            result.setSingleton(this.singleton);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("state")) {
            result.setState(this.state);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("instance")) {
            result.setInstance(this.instance);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("serverId")) {
            result.setServerId(this.serverId);
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("eventsData")) && this.eventsData != null) {
            result.getEvents().fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.eventsData))).getDocumentElement());
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("descriptionData")) {
            if (this.descriptionData != null) {
                Element root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.descriptionData))).getDocumentElement();
                L10nMessage l10nMessage = new L10nMessage();
                l10nMessage.setKey(XHelper.readString((Element)root, (String)"key"));
                l10nMessage.getParameters().clear();
                for (Element item : XmlUtil.getElements((Element)root, (String)"parameters/item")) {
                    l10nMessage.getParameters().add(XHelper.readObject((Element)item, (String)"."));
                }
                result.setDescription(l10nMessage);
            } else {
                result.setDescription(null);
            }
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("startDate")) {
            result.setStartDate(this.startDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("endDate")) {
            result.setEndDate(this.endDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("createdBy")) {
            result.setCreatedBy(this.createdBy);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("created")) {
            result.setCreated(this.created);
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("configuration")) && this.configuration != null) {
            result.setConfiguration(XUtil.deserialize((byte[])GZIPUtil.gunzip((byte[])this.configuration)));
        }
        return result;
    }

    public byte[] getEventsData() {
        return this.eventsData;
    }

    public void setEventsData(byte[] eventsData) {
        this.eventsData = eventsData;
    }

    public byte[] getDescriptionData() {
        return this.descriptionData;
    }

    public void setDescriptionData(byte[] descriptionData) {
        this.descriptionData = descriptionData;
    }

    public static enum Property {
        eventsData,
        descriptionData;

    }
}

