/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class OpeningBalanceData
extends BaseAssetData<OpeningBalance> {
    @Index(name="OpeningBalance_organizationUid")
    private String organizationUid;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="OpeningBalance_modified")
    private Date modified;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="OpeningBalance_operationDate")
    private Date operationDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="OpeningBalance_calculationDate")
    private Date calculationDate;
    @Index(name="OpeningBalance_debit")
    private long debit;
    @Index(name="OpeningBalance_credit")
    private long credit;
    @Index(name="OpeningBalance_accountUid")
    private String accountUid;
    @Index(name="OpeningBalance_dimension1")
    private String dimension1;
    @Index(name="OpeningBalance_dimension2")
    private String dimension2;
    @Index(name="OpeningBalance_dimension3")
    private String dimension3;
    @Index(name="OpeningBalance_auxiliary")
    private Boolean auxiliary;

    public void fromAsset(OpeningBalance asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.organizationUid = asset.getOrganizationUid();
        this.operationDate = asset.getOperationDate();
        this.calculationDate = asset.getCalculationDate();
        this.debit = asset.getDebit();
        this.credit = asset.getCredit();
        this.accountUid = asset.getAccountUid();
        this.dimension1 = asset.getDimension1();
        this.dimension2 = asset.getDimension2();
        this.dimension3 = asset.getDimension3();
        this.auxiliary = asset.isAuxiliary();
    }

    public OpeningBalance toAsset(Set<String> preferredProperties) {
        OpeningBalance result = new OpeningBalance(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        boolean empty = preferredProperties.isEmpty();
        if (empty || preferredProperties.contains(OpeningBalance.Property.organizationUid.name())) {
            result.setOrganizationUid(this.organizationUid);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.operationDate.name())) {
            result.setOperationDate(MiscUtil.cloneDate((Date)this.operationDate));
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.calculationDate.name())) {
            result.setCalculationDate(MiscUtil.cloneDate((Date)this.calculationDate));
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.debit.name())) {
            result.setDebit(this.debit);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.credit.name())) {
            result.setCredit(this.credit);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.accountUid.name())) {
            result.setAccountUid(this.accountUid);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.dimension1.name())) {
            result.setDimension1(this.dimension1);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.dimension2.name())) {
            result.setDimension2(this.dimension2);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.dimension3.name())) {
            result.setDimension3(this.dimension3);
        }
        if (empty || preferredProperties.contains(OpeningBalance.Property.auxiliary.name())) {
            result.setAuxiliary(this.auxiliary != null && this.auxiliary != false);
        }
        return result;
    }

    public Date getModified() {
        return MiscUtil.cloneDate((Date)this.modified);
    }

    public void setModified(Date date) {
        this.modified = date;
    }
}

