/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.model.assets.QuestionRecord;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class QuestionRecordData
extends BaseAssetData<QuestionRecord> {
    @Index(name="QuestionRecord_questionId")
    private String questionId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="QuestionRecord_modified")
    private Date modified;
    @Index(name="QuestionRecord_answered")
    private boolean answered;
    @Index(name="QuestionRecord_answerAttempts")
    private Integer answerAttempts;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="QuestionRecord_questionDate")
    private Date questionDate;
    @Lob
    @Column(length=0x40000000)
    private byte[] questionData;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void setAnswered(boolean answered) {
        this.answered = answered;
    }

    public void setAnswerAttempts(int answerAttempts) {
        this.answerAttempts = answerAttempts;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public void setQuestionData(byte[] questionData) {
        this.questionData = questionData;
    }

    public void setQuestionDate(Date questionDate) {
        this.questionDate = questionDate;
    }

    public QuestionRecord toAsset(Set<String> preferredProperties) throws Exception {
        QuestionRecord questionRecord = new QuestionRecord();
        questionRecord.setUid(this.getUid());
        questionRecord.setQuestionData(this.questionData);
        questionRecord.setQuestionId(this.questionId);
        questionRecord.setAnswered(this.answered);
        questionRecord.setAnswerAttempts(this.answerAttempts != null ? this.answerAttempts : 0);
        questionRecord.setQuestionDate(this.questionDate);
        return questionRecord;
    }

    public void fromAsset(QuestionRecord asset) throws Exception {
        this.setUid(asset.getUid());
        this.setAnswered(asset.isAnswered());
        this.setAnswerAttempts(asset.getAnswerAttempts());
        this.setQuestionId(asset.getQuestionId());
        this.setQuestionData(asset.getQuestionData());
        this.setQuestionDate(asset.getQuestionDate());
    }
}

