/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.assets;

import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.model.assets.WorkspaceCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.xml.sax.InputSource;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"owner", "category"})})
public class WorkspaceData
extends BaseAssetData<Workspace> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="WorkspaceData_modified")
    private Date modified;
    private String owner;
    @Enumerated(value=EnumType.STRING)
    private WorkspaceCategory category;
    private String name;
    @Lob
    @Column(length=0x40000000)
    private byte[] data = new byte[0];

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(Workspace asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.owner = asset.getOwner();
        this.category = asset.getCategory();
        this.name = asset.getName();
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset, (OutputStream)strm);
        this.data = strm.toByteArray();
    }

    public Workspace toAsset(Set<String> preferredProperties) throws Exception {
        Workspace result = new Workspace(this.getUid());
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.data))).getDocumentElement());
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("name")) {
            result.setName(this.name);
        }
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("category")) {
            result.setCategory(this.category);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("owner")) {
            result.setOwner(this.owner);
        }
        return result;
    }

    public void setData(byte[] value) {
        this.data = value;
    }

    public byte[] getData() {
        return this.data;
    }

    public static enum Property {
        data;

    }
}

