/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.aura;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.aura.Fields;
import com.gridnine.xtrip.server.model.aura.Parsers;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class Exporters {
    Exporters() {
    }

    public static ProductsExporter newProductsXlsxExporter(Path path) {
        return new ProductsXlsxExporter(path);
    }

    private static class ProductsXlsxExporter
    implements ProductsExporter {
        final Path path;

        ProductsXlsxExporter(Path path) {
            this.path = path;
        }

        @Override
        public void export(Collection<MiscUtil.Pair<Parsers.Product, Parsers.Product>> productBatches, Collection<Fields.ProductField> fields) throws Exception {
            try (XSSFWorkbook book = new XSSFWorkbook();){
                CellStyle style = book.createCellStyle();
                style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
                style.setFillPattern((short)1);
                Sheet sheet = book.createSheet("products");
                int rowIndex = 0;
                int columnIndex = 0;
                Row headerRow = sheet.createRow(0);
                for (int i = 0; i < 2; ++i) {
                    for (Fields.ProductField field : fields) {
                        Cell headerCell = headerRow.createCell(columnIndex);
                        headerCell.setCellValue(field.name());
                        ++columnIndex;
                    }
                }
                ++rowIndex;
                for (MiscUtil.Pair<Parsers.Product, Parsers.Product> productBatch : productBatches) {
                    Row row = sheet.createRow(rowIndex);
                    List values = IntStream.of(0, 1).mapToObj(item -> fields.stream().map(field -> {
                        Parsers.Product product = null;
                        if (item == 0) {
                            product = (Parsers.Product)productBatch.getFirst();
                        } else if (item == 1) {
                            product = (Parsers.Product)productBatch.getSecond();
                        }
                        if (product != null) {
                            if (field == Fields.ProductField.SYSTEM_NUMBER) {
                                return product.getSystemNumber();
                            }
                            if (field == Fields.ProductField.STATUS) {
                                return product.getStatus() != null ? product.getStatus().name() : null;
                            }
                            if (field == Fields.ProductField.AMOUNT) {
                                return product.getAmount();
                            }
                            if (field == Fields.ProductField.TAX) {
                                return product.getTax();
                            }
                            if (field == Fields.ProductField.COMMISSION) {
                                return product.getCommission();
                            }
                            if (field == Fields.ProductField.FOPS) {
                                return (Serializable)((Object)product.getFops().stream().sorted().collect(Collectors.joining(",")));
                            }
                        }
                        return null;
                    })).flatMap(item -> item).collect(Collectors.toList());
                    columnIndex = 0;
                    for (Object value : values) {
                        Cell cell = row.createCell(columnIndex);
                        if (value != null) {
                            if (value instanceof Date) {
                                cell.setCellValue((Date)value);
                            } else if (value instanceof Number) {
                                cell.setCellValue(((Number)value).doubleValue());
                            } else {
                                cell.setCellValue(value.toString());
                            }
                        }
                        if (!MiscUtil.equals(values.get(columnIndex % fields.size()), values.get(columnIndex % fields.size() + fields.size()))) {
                            cell.setCellStyle(style);
                        }
                        ++columnIndex;
                    }
                    ++rowIndex;
                }
                OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);
                Object object = null;
                try {
                    book.write(os);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (object != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
        }
    }

    static interface ProductsExporter {
        public void export(Collection<MiscUtil.Pair<Parsers.Product, Parsers.Product>> var1, Collection<Fields.ProductField> var2) throws Exception;
    }
}

