/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.aura;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.aura.Fields;
import com.gridnine.xtrip.server.model.aura.Indicators;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class Parsers {
    static final Map<String, String> fopCodes = new HashMap<String, String>();

    Parsers() {
    }

    static ProductsParser newProductsCsvParser(Path path, Predicate<Map<Fields.ProductField, String>> filter, String separator, Charset charset) {
        return new ProductsCsvParser(path, filter, separator, charset);
    }

    static {
        fopCodes.put("EX", "TI");
    }

    private static class ProductsCsvParser
    implements ProductsParser {
        private final DecimalFormat format;
        private final Predicate<Map<Fields.ProductField, String>> filter;
        private final Path path;
        private final String separator;
        private final Charset charset;

        ProductsCsvParser(Path path, Predicate<Map<Fields.ProductField, String>> filter, String separator, Charset charset) {
            this.path = path;
            this.filter = filter;
            this.separator = separator;
            this.charset = charset;
            this.format = (DecimalFormat)NumberFormat.getInstance(LocaleHelper.RU_LOCALE);
            this.format.setParseBigDecimal(true);
        }

        @Override
        public ProductParserResult parse() throws Exception {
            LinkedHashMap<String, Product> products = new LinkedHashMap<String, Product>();
            int count = 0;
            HashMap<Fields.ProductField, Integer> codes = new HashMap<Fields.ProductField, Integer>();
            HashMap<Fields.ProductField, String> values = new HashMap<Fields.ProductField, String>();
            List<String> lines = Files.readAllLines(this.path, this.charset);
            Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator(String.format("parsing %s", this.path.toString()), lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                String code;
                indicator.update(i);
                String line = lines.get(i);
                String[] entries = line.split(this.separator, -1);
                if (i == 0) {
                    count = entries.length;
                    int index = 0;
                    for (String entry : entries) {
                        Fields.ProductField field = null;
                        try {
                            field = Fields.ProductField.valueOf(entry.trim());
                            if (!codes.containsKey((Object)field)) {
                                codes.put(field, index);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++index;
                    }
                    continue;
                }
                if (entries.length != count) {
                    throw new IllegalStateException("corrupted record -> " + line);
                }
                values.clear();
                values.putAll(codes.entrySet().stream().collect(Collectors.toMap(item -> (Fields.ProductField)((Object)((Object)item.getKey())), item -> entries[(Integer)codes.get(item.getKey())].trim())));
                if (this.filter != null && !this.filter.test(values)) continue;
                String systemNumber = (String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER);
                String string = systemNumber = !TextUtil.isBlank((String)systemNumber) ? systemNumber.replaceAll("\\s+", "") : null;
                if (TextUtil.isBlank((String)systemNumber)) {
                    throw new IllegalStateException("no system number defined -> " + line);
                }
                String statusCode = (String)values.get((Object)Fields.ProductField.STATUS);
                ProductStatus status = null;
                if (TextUtil.isSame((String)statusCode, (String)"SALE")) {
                    status = ProductStatus.SELL;
                } else if (TextUtil.isSame((String)statusCode, (String)"REFUND")) {
                    status = ProductStatus.REFUND;
                } else if (TextUtil.isSame((String)statusCode, (String)"EXC")) {
                    status = ProductStatus.EXCHANGE;
                } else if (TextUtil.isSame((String)statusCode, (String)"CANCEL")) {
                    status = ProductStatus.VOID;
                }
                if (status == null) {
                    throw new IllegalStateException("no status defined -> " + line);
                }
                String amountValue = (String)values.get((Object)Fields.ProductField.AMOUNT);
                amountValue = !TextUtil.isBlank((String)amountValue) ? amountValue.replaceAll("\\s+", "") : null;
                BigDecimal amount = null;
                if (!TextUtil.isBlank((String)amountValue)) {
                    try {
                        amount = (BigDecimal)this.format.parse(amountValue);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("no amount defined -> " + line);
                    }
                } else {
                    amount = BigDecimal.ZERO;
                }
                String taxValue = (String)values.get((Object)Fields.ProductField.TAX);
                taxValue = !TextUtil.isBlank((String)taxValue) ? taxValue.replaceAll("\\s+", "") : null;
                BigDecimal tax = null;
                if (!TextUtil.isBlank((String)taxValue)) {
                    try {
                        tax = (BigDecimal)this.format.parse(taxValue);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("no tax defined -> " + line);
                    }
                } else {
                    tax = BigDecimal.ZERO;
                }
                String commissionValue = (String)values.get((Object)Fields.ProductField.COMMISSION);
                commissionValue = !TextUtil.isBlank((String)commissionValue) ? commissionValue.replaceAll("\\s+", "") : null;
                BigDecimal commission = null;
                if (!TextUtil.isBlank((String)commissionValue)) {
                    try {
                        commission = (BigDecimal)this.format.parse(commissionValue);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("no commission defined -> " + line);
                    }
                } else {
                    commission = BigDecimal.ZERO;
                }
                String fopsValue = (String)values.get((Object)Fields.ProductField.FOPS);
                HashSet fops = new HashSet();
                if (!TextUtil.isBlank((String)fopsValue)) {
                    fops.clear();
                    fops.addAll(Arrays.asList(fopsValue.split("[;,\\s]")).stream().filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).map(item -> fopCodes.get(item) != null ? fopCodes.get(item) : item).collect(Collectors.toSet()));
                }
                Product product = products.get(code = String.format("%s_%s", status, systemNumber)) != null ? (Product)products.get(code) : new Product();
                product.setCode(code);
                if (product.getSystemNumber() == null) {
                    product.setSystemNumber(systemNumber);
                }
                if (product.getStatus() == null) {
                    product.setStatus(status);
                }
                product.setAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getAmount(), amount}));
                product.setTax(MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTax(), tax}));
                product.setCommission(MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getCommission(), commission}));
                product.getFops().clear();
                product.getFops().addAll(fops);
                products.put(code, product);
            }
            ProductParserResult result = new ProductParserResult();
            result.getProducts().clear();
            result.getProducts().addAll(products.values());
            return result;
        }
    }

    static interface ProductsParser {
        public ProductParserResult parse() throws Exception;
    }

    static class ProductParserResult {
        private final Collection<Product> products = new ArrayList<Product>();

        ProductParserResult() {
        }

        public Collection<Product> getProducts() {
            return this.products;
        }
    }

    static class Product {
        private String code;
        private String systemNumber;
        private ProductStatus status;
        private BigDecimal amount;
        private BigDecimal tax;
        private BigDecimal commission;
        private final Set<String> fops = new HashSet<String>();

        Product() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getSystemNumber() {
            return this.systemNumber;
        }

        public void setSystemNumber(String systemNumber) {
            this.systemNumber = systemNumber;
        }

        public ProductStatus getStatus() {
            return this.status;
        }

        public void setStatus(ProductStatus status) {
            this.status = status;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getTax() {
            return this.tax;
        }

        public void setTax(BigDecimal tax) {
            this.tax = tax;
        }

        public BigDecimal getCommission() {
            return this.commission;
        }

        public void setCommission(BigDecimal commission) {
            this.commission = commission;
        }

        public Set<String> getFops() {
            return this.fops;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.systemNumber);
            stringBuilder.append("-");
            stringBuilder.append(this.status);
            stringBuilder.append("-");
            stringBuilder.append(this.amount != null ? this.amount.toPlainString() : "?");
            stringBuilder.append("-");
            stringBuilder.append(this.tax != null ? this.tax.toPlainString() : "?");
            stringBuilder.append("-");
            stringBuilder.append(this.commission != null ? this.commission.toPlainString() : "?");
            stringBuilder.append("-");
            stringBuilder.append(this.fops.size() > 0 ? this.fops.stream().collect(Collectors.joining(",")) : "?");
            return stringBuilder.toString();
        }
    }
}

