/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.aura;

import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.aura.Exporters;
import com.gridnine.xtrip.server.model.aura.Fields;
import com.gridnine.xtrip.server.model.aura.Indicators;
import com.gridnine.xtrip.server.model.aura.Parsers;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.junit.Ignore;
import org.junit.Test;

public class ProductsCompareTest
extends TestBase {
    @Ignore
    @Test
    public void mergeGeoLocations() throws Exception {
        MiscUtil.Pair productBatch;
        Parsers.ProductParserResult xtripProductsParserResult = Parsers.newProductsCsvParser(Paths.get("c:/aura/xtrip/report.csv", new String[0]), null, ";", Charset.forName("cp1251")).parse();
        Parsers.ProductParserResult bileturProductsParserResult = Parsers.newProductsCsvParser(Paths.get("c:/aura/biletur/report.csv", new String[0]), values -> (!TextUtil.isBlank((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER))) || !TextUtil.isBlank((String)((String)values.get((Object)Fields.ProductField.AMOUNT)))) && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u2116 \u0411\u0421\u041e") && !TextUtil.isLike((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0431\u043e\u0440\u043e\u0432") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0431\u043e\u0440\u043e\u0432") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0431\u043e\u0440\u043e\u0432") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0431\u043e\u0440\u043e\u0432") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0431\u0430\u0433\u0430\u0436\u0430") && !TextUtil.isSame((String)((String)values.get((Object)Fields.ProductField.SYSTEM_NUMBER)), (String)"\u0412\u0441\u0435\u0433\u043e \u043f\u043e \u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0431\u0430\u0433\u0430\u0436\u0430"), ";", Charset.forName("cp1251")).parse();
        Map<String, Parsers.Product> xtripProducts = xtripProductsParserResult.getProducts().stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        Map<String, Parsers.Product> bileturProducts = bileturProductsParserResult.getProducts().stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        TreeMap<String, MiscUtil.Pair> productBatches = new TreeMap<String, MiscUtil.Pair>();
        for (Map.Entry<String, Parsers.Product> entry : xtripProducts.entrySet()) {
            productBatch = productBatches.computeIfAbsent(entry.getKey(), item -> new MiscUtil.Pair());
            productBatch.setFirst((Object)entry.getValue());
        }
        for (Map.Entry<String, Parsers.Product> entry : bileturProducts.entrySet()) {
            productBatch = productBatches.computeIfAbsent(entry.getKey(), item -> new MiscUtil.Pair());
            productBatch.setSecond((Object)entry.getValue());
        }
        Indicators.ProgressIndicator indicator = Indicators.newDescreteProgressIndicator("checking divergences", productBatches.size());
        int count = 0;
        Iterator iterator = productBatches.values().iterator();
        while (iterator.hasNext()) {
            indicator.update(count);
            MiscUtil.Pair productBatch2 = (MiscUtil.Pair)iterator.next();
            if (productBatch2.getFirst() != null && productBatch2.getSecond() != null && ((Parsers.Product)productBatch2.getFirst()).getAmount().compareTo(((Parsers.Product)productBatch2.getSecond()).getAmount()) == 0 && ((Parsers.Product)productBatch2.getFirst()).getTax().compareTo(((Parsers.Product)productBatch2.getSecond()).getTax()) == 0 && ((Parsers.Product)productBatch2.getFirst()).getCommission().compareTo(((Parsers.Product)productBatch2.getSecond()).getCommission()) == 0 && ((Parsers.Product)productBatch2.getFirst()).getFops().equals(((Parsers.Product)productBatch2.getSecond()).getFops())) {
                iterator.remove();
            }
            ++count;
        }
        Exporters.newProductsXlsxExporter(Paths.get("c:/aura/divergences.xlsx", new String[0])).export(productBatches.values(), Arrays.asList(Fields.ProductField.values()));
    }
}

