/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.asset;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfiguration;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheData;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheUpdater;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerManager;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCache;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheCleaner;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheUpdater;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsProvider;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import com.gridnine.xtrip.server.model.cache.asset.TestAssetsActualStorage;
import com.gridnine.xtrip.server.model.cache.asset.TestAssetsCacheModificationDataUpdater;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.File;

abstract class AssetsCacheTestBase
extends ModelTestBase {
    protected TestAssetsActualStorage actualStorage = new TestAssetsActualStorage();
    protected AssetsCacheUpdater cacheUpdater;
    protected TestAssetsCacheModificationDataUpdater modificationCacheUpdater;

    AssetsCacheTestBase() {
    }

    protected void publishAssetStorage() {
        AssetsCacheConfiguration configuration = new AssetsCacheConfiguration();
        configuration.setUpdatePeriodInSeconds(0);
        this.configureAssetsStorage(configuration);
        AssetsCacheServerManager.publish((AssetsCacheServerManager.AssetsCacheServerFactory)new AssetsCacheServerManager.AssetsCacheServerFactory(){

            public AssetsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> provider, AssetsCacheConfiguration config, CacheState cacheState, AssetsCacheData cacheData) {
                AssetsCacheTestBase.this.cacheUpdater = new AssetsCacheUpdater(provider, cacheData, cacheState, config);
                return AssetsCacheTestBase.this.cacheUpdater;
            }

            public AssetsCacheActualStorage createActualStorage() {
                return AssetsCacheTestBase.this.actualStorage;
            }

            public AssetsCacheServerModificationsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> modificationsProvider, AssetsCacheServerModificationsCache cache, AssetsCacheConfiguration config) {
                AssetsCacheTestBase.this.modificationCacheUpdater = new TestAssetsCacheModificationDataUpdater(modificationsProvider, cache, config);
                return AssetsCacheTestBase.this.modificationCacheUpdater;
            }

            public AssetsCacheServerModificationsCache createModificationsCache(AssetsCacheConfiguration config) {
                return new AssetsCacheServerModificationsCache(config, new File(Environment.getDataFolder(), "assets-modifications/"));
            }

            public CacheDataModificationProvider<AssetReference<?>> createModificationProvider() {
                return new AssetsCacheServerModificationsProvider();
            }

            public AssetsCacheServerModificationsCacheCleaner createCleaner(AssetsCacheServerModificationsCache cache) {
                return new AssetsCacheServerModificationsCacheCleaner(cache, 0, 72);
            }

            public CacheDataModificationsServerCacheData<AssetReference<?>> createCacheData() {
                return new CacheDataModificationsServerCacheData();
            }

            public CacheState createState() {
                return new CacheState();
            }
        }, (AssetsCacheConfiguration)configuration);
        this.log.info("assets storage successfully registered");
    }

    AssetsCacheManager getManager() {
        return (AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class);
    }
}

