/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.cache.asset.DeletedAssetReference;
import com.gridnine.xtrip.server.model.cache.asset.AssetsCacheTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BasicAssetsCacheIntegrationTest
extends AssetsCacheTestBase {
    @Test
    public void testBasic() throws Exception {
        this.actualStorage.resetCounters();
        this.getManager().reset();
        UserAccount account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        account = (UserAccount)AssetsStorage.get().load(UserAccount.class, account.getUid());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        this.actualStorage.resetCounters();
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((long)0L, (long)this.actualStorage.getSearchRequestsCount());
        account = (UserAccount)AssetsStorage.get().load(UserAccount.class, account.getUid());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        this.actualStorage.resetCounters();
        account.setFullName("Admin 2");
        AssetsStorage.get().save((BaseAsset)account, false);
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((Object)"Admin 2", (Object)account.getFullName());
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        account = (UserAccount)AssetsStorage.get().load(UserAccount.class, account.getUid());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        account = new UserAccount();
        account.setUid("testAccount");
        account.setActive(true);
        account.setFullName("Test User");
        account.setLoginName("test");
        account.setPassword("test".toCharArray());
        AssetsStorage.get().save((BaseAsset)account);
        this.actualStorage.resetCounters();
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"test");
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        account = (UserAccount)AssetsStorage.get().load(UserAccount.class, account.getUid());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        AssetsStorage.get().delete((BaseAsset)account);
        this.actualStorage.resetCounters();
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"test");
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertNull((Object)account);
        account = (UserAccount)AssetsStorage.get().load(UserAccount.class, "testAccount");
        Assert.assertEquals((long)1L, (long)this.actualStorage.getLoadRequestsCount());
        Assert.assertNull((Object)account);
        Assert.assertNotNull((Object)AssetsStorage.get().find(DeletedAssetReference.class, "assetUid", (Object)"testAccount"));
        this.actualStorage.resetCounters();
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((Object)"Admin 2", (Object)account.getFullName());
        account.setFullName("Admin");
        AssetsStorage.get().save((BaseAsset)account, true);
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getSearchRequestsCount());
        this.modificationCacheUpdater.check();
        this.cacheUpdater.check();
        account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)"admin");
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getLoadRequestsCount());
        Assert.assertEquals((Object)"Admin", (Object)account.getFullName());
    }
}

