/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.dict;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Test;

public class ConcurrentDictCacheTest
extends ModelTestBase {
    @Test
    public void testSearchByIndexDuringUpdate() throws Exception {
        DictionaryCache dictCache = DictionaryCache.get();
        int iterationsNumber = 10000;
        Runnable searchTask = () -> {
            for (int i = 0; i < iterationsNumber; ++i) {
                HashSet geoLocations = new HashSet(dictCache.search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.type.name(), (Object)LocationType.CITY)));
                if (geoLocations.size() >= 0) continue;
                throw new RuntimeException("Error");
            }
        };
        Runnable modifyTask = () -> {
            for (int i = 0; i < iterationsNumber; ++i) {
                GeoLocation geoLocation = new GeoLocation();
                geoLocation.setCode(String.valueOf(ThreadLocalRandom.current().nextInt()));
                geoLocation.setType(LocationType.CITY);
                dictCache.put((BaseDictionary)geoLocation);
            }
        };
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService executer = Executors.newFixedThreadPool(availableProcessors);
        int numberTask = availableProcessors / 2;
        if (numberTask == 0) {
            numberTask = 1;
        }
        List futures = IntStream.range(0, numberTask).boxed().flatMap(i -> Stream.of(executer.submit(searchTask), executer.submit(modifyTask))).collect(Collectors.toList());
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            executer.shutdownNow();
            throw e;
        }
    }
}

