/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.entity;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.server.model.cache.entity.AECTestBase;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class BasicAECIntegrationTest
extends AECTestBase {
    @Test
    public void testBasic() throws Exception {
        EntityStorage cache = EntityStorage.get();
        this.actualStorage.resetCounters();
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1"));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getResolveRequestsCount());
        this.actualStorage.resetCounters();
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1"));
        Assert.assertEquals((long)0L, (long)this.actualStorage.getSearchRequestsCount());
        EntityContainer<Person> ctr1 = this.createAgent("login1", "name1");
        EntityReference ref = ctr1.toReference();
        this.actualStorage.resetCounters();
        Assert.assertEquals(ctr1, (Object)cache.resolve(ctr1.toReference()));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        Assert.assertEquals(ctr1, (Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1"));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        L10nStringHelper.setValue((L10nString)((Person)ctr1.getEntity()).getLastName(), (String)"name2", (Locale)Locale.ENGLISH);
        cache.save(ctr1, false);
        this.actualStorage.resetCounters();
        L10nString lastName = ((Person)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1").getEntity()).getLastName();
        this.log.debug("last name is " + lastName);
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        Assert.assertEquals((Object)"name2", (Object)L10nStringHelper.getValue((L10nString)((Person)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1").getEntity()).getLastName(), (Locale)Locale.ENGLISH, (boolean)false));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        this.actualStorage.resetCounters();
        cache.actualize(ref, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        Assert.assertEquals((Object)"name2", (Object)ref.getCaption());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getReferenceActualizationRequestsCount());
        cache.actualize(ref);
        Assert.assertEquals((Object)"name2", (Object)ref.getCaption());
        Assert.assertEquals((long)0L, (long)this.actualStorage.getReferenceActualizationRequestsCount());
        ((Person)ctr1.getEntity()).setLoginName("login2");
        cache.save(ctr1, false);
        this.actualStorage.resetCounters();
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1"));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login1"));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals(ctr1, (Object)cache.resolve(ctr1.toReference()));
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        Assert.assertEquals(ctr1, (Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login2"));
        Assert.assertEquals((long)2L, (long)this.actualStorage.getSearchRequestsCount());
        Assert.assertEquals((long)1L, (long)this.actualStorage.getResolveRequestsCount());
        cache.delete(ctr1);
        this.actualStorage.resetCounters();
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login2"));
        Assert.assertNull((Object)cache.resolve(ctr1.toReference()));
        Assert.assertNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login3"));
        Person person = new Person();
        person.setLoginName("login3");
        person.getFirstName().setStringValue("login3");
        EntityStorage.get().save(EntityContainer.create((BaseEntity)person), true);
        Assert.assertNotNull((Object)cache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)"login3"));
        EntityReference ref2 = new EntityReference("test-uid", Person.class, String.format(L10n.get((String)Messages.AdvancedCachedEntityStorage_deleted2), "test"));
        cache.actualize(ref2, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        String caption = ref2.getCaption();
        cache.actualize(ref2, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        Assert.assertEquals((Object)caption, (Object)ref2.getCaption());
    }

    private EntityContainer<Person> createAgent(String login, String name) throws Exception {
        EntityContainer ctr = new EntityContainer(Person.class);
        ((Person)ctr.getEntity()).setActive(true);
        ((Person)ctr.getEntity()).setLoginName(login);
        L10nStringHelper.setValue((L10nString)((Person)ctr.getEntity()).getLastName(), (String)name, (Locale)Locale.ENGLISH);
        EntityStorage.get().save(ctr, false);
        return ctr;
    }
}

