/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.entity;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECEntityHandler;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.model.cache.entity.AECTestBase;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class ConcurrentEntityLoadTest
extends AECTestBase {
    private static final String MIDOFFICE_ENTITY_CACHE_USE_LOCK = "midoffice.entity-cache.useLock";

    public void setUp() throws Exception {
        System.setProperty(MIDOFFICE_ENTITY_CACHE_USE_LOCK, "true");
        super.setUp();
    }

    public void tearDown() throws Exception {
        System.setProperty(MIDOFFICE_ENTITY_CACHE_USE_LOCK, "false");
        super.tearDown();
    }

    @Test
    public void testNoLock() throws Exception {
        EntityContainer ctr = new EntityContainer(TestContract.class);
        final EntityReference ref = ctr.toReference();
        EntityStorage.get().save(ctr, true);
        this.actualStorage.resetCounters();
        ExecutorServiceFacade executor = (ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class);
        ArrayList<Future> futures = new ArrayList<Future>(10);
        for (int n = 0; n < 10; ++n) {
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    EntityStorage.get().resolve(ref);
                }
            }));
        }
        for (Future item : futures) {
            item.get();
        }
        int count = this.actualStorage.getResolveRequestsCount();
        Assert.assertEquals((long)1L, (long)count);
    }

    protected void configureEntityCache(AECConfiguration config) {
        super.configureEntityCache(config);
        config.register((AECEntityHandler)new AECEntityHandler<TestContract>(){

            public Class<TestContract> getEntityType() {
                return TestContract.class;
            }

            public boolean accept(TestContract item) {
                return true;
            }
        });
    }

    public static class TestContract
    extends Contract {
        private static final long serialVersionUID = 8603549393611503679L;

        public void fromXML(Element elm) throws Exception {
            super.fromXML(elm);
            Thread.sleep(5000L);
        }
    }
}

