/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cache.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.ReferenceActualizationResult;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerActualStorage;

class TestAECActualStorage
extends AECServerActualStorage {
    private int searchRequestsCount;
    private int resolveRequestsCount;
    private int referenceActualizationRequestsCount;

    TestAECActualStorage() {
    }

    public <E extends BaseEntity> ReferenceActualizationResult<E> actualizeReference(EntityReference<E> ref, EntityStorageActualizeParameters parameters) throws Exception {
        ++this.referenceActualizationRequestsCount;
        return super.actualizeReference(ref, parameters);
    }

    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, Integer versionNumber) throws Exception {
        ++this.resolveRequestsCount;
        return super.load(cls, uid, versionNumber);
    }

    public <E extends BaseEntity> EntityContainer<E> load(EntityReference<E> ref, EntityStorageLoadParameters parameters) throws Exception {
        ++this.resolveRequestsCount;
        return super.load(ref, parameters);
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws Exception {
        ++this.searchRequestsCount;
        return super.search(cls, query, parameters);
    }

    int getReferenceActualizationRequestsCount() {
        return this.referenceActualizationRequestsCount;
    }

    int getResolveRequestsCount() {
        return this.resolveRequestsCount;
    }

    int getSearchRequestsCount() {
        return this.searchRequestsCount;
    }

    void resetCounters() {
        this.resolveRequestsCount = 0;
        this.referenceActualizationRequestsCount = 0;
        this.searchRequestsCount = 0;
    }
}

