/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class CleanupCurrencyRatesTask
extends BaseScheduledTask {
    private static final String MONTHS_PARAM_NAME = "months";
    private int months = 12;

    protected void configure(Properties properties) throws Exception {
        super.configure(properties);
        String param = properties.getProperty(MONTHS_PARAM_NAME);
        if (TextUtil.nonBlank((String)param)) {
            this.months = Integer.parseInt(param);
        }
    }

    protected void doJob() throws Exception {
        Date deadline = MiscUtil.toDate((LocalDateTime)LocalDateTime.now().minusMonths(this.months));
        this.log.debug("delete currency rates before " + deadline);
        DictionaryCache cache = DictionaryCache.get();
        Map all = cache.getAll(CurrencyRate.class);
        this.log.debug("have got " + all.size() + " rates");
        int p = 0;
        for (CurrencyRate rate : all.values()) {
            if (rate.getDate() == null || !rate.getDate().before(deadline)) continue;
            DictionaryStorage.get().delete((BaseDictionary)rate);
            ++p;
        }
        this.log.info("delete currency rates done, " + p + " rates deleted");
    }
}

