/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.model.cleanup.CleanupObjectsTaskConfiguration;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.cleanup.CleanupObjectsTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import java.util.Properties;

public class CleanupObjectsScheduledTask
extends BaseScheduledTask {
    public static final String SETTINGS_INCLUDE_KEY = "INCLUDE_CODES";
    public static final String SETTINGS_IGNORE_KEY = "IGNORE_CODES";
    public static final String THREADS_COUNT = "THREADS_COUNT";
    private String includeKeys;
    private String ignoreKeys;
    private int threadsCount;

    protected void configure(Properties properties) throws Exception {
        super.configure(properties);
        this.ignoreKeys = properties.getProperty(SETTINGS_IGNORE_KEY);
        this.includeKeys = properties.getProperty(SETTINGS_INCLUDE_KEY);
        String threadsCountValue = properties.getProperty(THREADS_COUNT);
        this.threadsCount = TextUtil.isBlank((String)threadsCountValue) ? 1 : Integer.parseInt(threadsCountValue);
    }

    protected void doJob() throws Exception {
        CleanupObjectsTask task = new CleanupObjectsTask();
        CleanupObjectsTaskConfiguration config = new CleanupObjectsTaskConfiguration();
        config.setIgnoreCodes(this.ignoreKeys);
        config.setIncludeCodes(this.includeKeys);
        config.setThreadsCount(this.threadsCount);
        task.configure(config);
        try {
            task.doJob(new LongRunningTask.EventsCallback(){

                @Override
                public void updateProgress(byte progress) {
                    CleanupObjectsScheduledTask.this.log.info(String.format("progress updated " + progress, new Object[0]));
                }

                @Override
                public void taskFinished() {
                    CleanupObjectsScheduledTask.this.log.info("task finished");
                }

                @Override
                public void addEvent(String eventId, Message description) {
                    switch (description.getType()) {
                        case MESSAGE: {
                            CleanupObjectsScheduledTask.this.log.debug(this.format(description));
                            return;
                        }
                        case WARNING: {
                            CleanupObjectsScheduledTask.this.log.warn(this.format(description));
                            return;
                        }
                        case ERROR: {
                            CleanupObjectsScheduledTask.this.log.error(this.format(description));
                            return;
                        }
                    }
                }

                private String format(Message description) {
                    if (TextUtil.isBlank((String)description.getDetails())) {
                        return description.getMessage().toString();
                    }
                    return String.format("%s, details:\n%s", description.getMessage().toString(), description.getDetails());
                }
            });
        }
        catch (InterruptedException e) {
            task.stop();
        }
    }
}

