/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.cleanup.CleanupObjectsTaskConfiguration;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.CleanupObjectsSettings;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.helpers.TrashBinHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CleanupObjectsTask
extends BaseQueryObjectsTask<CleanupObjectsTaskConfiguration> {
    private static final String countMsg = "\u0441\u0447\u0438\u0442\u0430\u0435\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f";
    int totalCount = 0;

    @Override
    protected boolean isSearchIrrelevanceTolerant() {
        return true;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.CleanupObjectsTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.CLEANUP_OBJECTS_SETTINGS));
        HashSet<CleanupObjectsSettings> toProcess = new HashSet<CleanupObjectsSettings>();
        for (BasicSystemSettingsIndex idx : EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData()) {
            EntityContainer settingsCtr = EntityStorage.get().resolve(idx.getSource());
            if (settingsCtr == null) {
                this.log.error(String.format("unable to load cleanup settings with uid %s", idx.getSource()));
                continue;
            }
            CleanupObjectsSettings settings = (CleanupObjectsSettings)settingsCtr.getEntity();
            HashSet<String> keys = new HashSet<String>();
            this.fillKeys(keys, ((CleanupObjectsTaskConfiguration)this.config).getIncludeCodes());
            if (!(keys.isEmpty() || !TextUtil.isBlank((String)settings.getCode()) && keys.contains(settings.getCode()))) {
                this.log.debug(String.format("cleanup setting %s with code %s was ignored due to include key restriction", settings, settings.getCode()));
                continue;
            }
            keys = new HashSet();
            this.fillKeys(keys, ((CleanupObjectsTaskConfiguration)this.config).getIgnoreCodes());
            if (!keys.isEmpty() && !TextUtil.isBlank((String)settings.getCode()) && keys.contains(settings.getCode())) {
                this.log.debug(String.format("cleanup setting %s with code %s was ignored due to ignore key restriction", settings, settings.getCode()));
                continue;
            }
            toProcess.add(settings);
        }
        this.log.debug(String.format("got %s settings", Integer.toString(toProcess.size())));
        if (toProcess.isEmpty()) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CleanupObjectsTask_noSettings, (Object[])new Object[0]));
            callback.updateProgress((byte)100);
            callback.taskFinished();
            return;
        }
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)countMsg, (Object[])new Object[0]));
        for (CleanupObjectsSettings item : toProcess) {
            this.log.debug(String.format("analizing  settings %s", item));
            int count = this.count(this.createCallback(item), XHelper.getClass((String)item.getObjectClassName()));
            this.totalCount += count;
            this.log.debug(String.format("settings %s: has %s objects to delete", item, Integer.toString(count)));
        }
        this.log.debug(String.format("Overall: has %s objects to delete", Integer.toString(this.totalCount)));
        for (CleanupObjectsSettings item : toProcess) {
            this.log.debug(String.format("starting deletion of objects for settings %s", item));
            this.processObjects(item.getObjectClassName(), callback, this.createCallback(item));
        }
        this.log.debug("process completed");
        callback.updateProgress((byte)100);
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0438\u0437 {1}", (Object[])new Object[]{this.totalCount, this.totalCount}));
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final CleanupObjectsSettings item) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALLIAS = "uidAllias";
            private static final String ENTITY_TYPE_ALLIAS = "entityTypeAllias";

            @Override
            public int getThreadsCount() {
                return ((CleanupObjectsTaskConfiguration)CleanupObjectsTask.this.config).getThreadsCount();
            }

            @Override
            public int getTotalCount() {
                return CleanupObjectsTask.this.totalCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) throws Exception {
                if (BaseAsset.class.isAssignableFrom(objectClass)) {
                    String uid = obj.get(UID_ALLIAS);
                    BaseAsset asset = AssetsStorage.get().load(objectClass, uid);
                    if (asset == null) {
                        CleanupObjectsTask.this.log.warn(String.format("no object of type %s with uid %s cannot be loaded", MiscUtil.getSimpleClassName(objectClass), uid));
                        return;
                    }
                    AssetsStorage.get().delete(asset, item.isIgnoreInterceptors());
                    CleanupObjectsTask.this.log.debug(String.format("object %s was deleted", asset));
                    return;
                }
                TrashBinHelper.setIgnoreTrashBin(true);
                try {
                    String uid = obj.get(UID_ALLIAS);
                    String entityType = obj.get(ENTITY_TYPE_ALLIAS);
                    EntityContainer ctr = EntityStorage.get().load(XHelper.getClass((String)entityType), uid);
                    if (ctr == null) {
                        CleanupObjectsTask.this.log.warn(String.format("no object of type %s with uid %s cannot be loaded", entityType, uid));
                        return;
                    }
                    EntityStorage.get().delete(ctr, (EntityStorageDeleteParameters)new EntityStorageDeleteParameters().ignoreInterceptors(item.isIgnoreInterceptors()));
                    CleanupObjectsTask.this.log.debug(String.format("object %s was deleted", ctr.getEntity()));
                }
                finally {
                    TrashBinHelper.setIgnoreTrashBin(false);
                }
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                if (BaseAsset.class.isAssignableFrom(cls)) {
                    return Collections.singleton(Projection.property((String)"uid", (String)UID_ALLIAS));
                }
                ArrayList<Projection> result = new ArrayList<Projection>();
                result.add(Projection.property((String)"containerUid", (String)UID_ALLIAS));
                result.add(Projection.property((String)"entityType", (String)ENTITY_TYPE_ALLIAS));
                return result;
            }

            @Override
            public String getThreadPrefix() {
                return "cleanup";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                return item.getCriterions();
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALLIAS);
            }
        };
    }

    private void fillKeys(Set<String> coll, String keys) {
        if (TextUtil.isBlank((String)keys)) {
            return;
        }
        for (String item : keys.split(",")) {
            if (TextUtil.isBlank((String)item)) continue;
            coll.add(item.trim());
        }
    }
}

