/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.CleanupObjectsSettings;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.cleanup.CleanupObjectsScheduledTask;

public class CleanupObjectsTaskSettingsInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        CleanupObjectsSettings settings = this.cast(data);
        if (settings == null || !this.isCorrect(settings)) {
            return;
        }
        EntityContainer ctr = this.find(settings.getCode());
        if (ctr != null) {
            return;
        }
        ctr = new EntityContainer(ScheduledTaskSettings.class);
        NamedValue param = new NamedValue();
        param.setName("INCLUDE_CODES");
        param.setValue(settings.getCode());
        ((ScheduledTaskSettings)ctr.getEntity()).getDataMap().add(param);
        ScheduledTaskSettings stt = (ScheduledTaskSettings)ctr.getEntity();
        stt.setName(String.format("\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430: %s", settings.getName()));
        stt.setEnabled(false);
        stt.setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
        stt.setJobClass(CleanupObjectsScheduledTask.class.getName());
        stt.setCron(null);
        stt.setDelay(Long.valueOf(60000L));
        stt.setPeriod(Long.valueOf(3600000L));
        EntityStorage.get().save(ctr, true);
    }

    private boolean isCorrect(CleanupObjectsSettings settings) {
        if (settings.getObjectClassName() == null) {
            return false;
        }
        return settings.getCode() != null;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        CleanupObjectsSettings settings = this.cast(data);
        if (settings == null) {
            return;
        }
        EntityContainer<ScheduledTaskSettings> taskSettingsCtr = this.find(settings.getCode());
        if (taskSettingsCtr != null) {
            EntityStorage.get().delete(taskSettingsCtr);
        }
    }

    private EntityContainer<ScheduledTaskSettings> find(String code) {
        for (BasicSystemSettingsIndex item : EntityStorage.get().search(BasicSystemSettingsIndex.class, new SearchQuery()).getData()) {
            BaseSystemSettings ett;
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null || !((ett = (BaseSystemSettings)ctr.getEntity()) instanceof ScheduledTaskSettings)) continue;
            ScheduledTaskSettings stt = (ScheduledTaskSettings)ett;
            if (!CleanupObjectsScheduledTask.class.getName().equals(stt.getJobClass())) continue;
            for (NamedValue param : stt.getDataMap()) {
                if (!"INCLUDE_CODES".equals(param.getName()) || !code.equals(param.getValue())) continue;
                return ctr;
            }
        }
        return null;
    }

    private CleanupObjectsSettings cast(EntityContainer<?> data) {
        if (data == null) {
            return null;
        }
        if (data.getEntity() instanceof CleanupObjectsSettings) {
            return (CleanupObjectsSettings)data.getEntity();
        }
        return null;
    }
}

