/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.DeleteBookingFileRelatedObjectsTaskConfiguration;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DeleteBookingFileRelatedObjectsTask
extends BaseQueryObjectsTask<DeleteBookingFileRelatedObjectsTaskConfiguration> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getEntityType((String)DeleteBookingFileRelatedObjectsTaskConfiguration.class.getName()).getDisplayName(), (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        int totalCount = this.count(this.createCallback(0), BookingFileIndex.class);
        this.processObjects(BookingFileIndex.class.getName(), callback, this.createCallback(totalCount));
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final int totalCount) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALLIAS = "uidAllias";

            @Override
            public int getThreadsCount() {
                return ((DeleteBookingFileRelatedObjectsTaskConfiguration)DeleteBookingFileRelatedObjectsTask.this.config).getThreadCount();
            }

            @Override
            public int getTotalCount() {
                return totalCount;
            }

            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) {
                String uid = obj.get(UID_ALLIAS);
                EntityReference item = new EntityReference(uid, BookingFile.class, null);
                DeleteBookingFileRelatedObjectsTask.this.log.debug("analyzing booking " + item.getUid());
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)item));
                query.getPreferredProperties().add("uid");
                for (BasicDocumentIndex idx : EntityStorage.get().search(BasicDocumentIndex.class, query).getData()) {
                    DeleteBookingFileRelatedObjectsTask.this.log.debug("deleting document " + idx.getSource().getUid());
                    EntityStorage.get().delete(idx.getSource());
                }
                query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)item.getUid()));
                query.getPreferredProperties().add("uid");
                for (SysLogItem sli : AssetsStorage.get().search(SysLogItem.class, query).getData()) {
                    DeleteBookingFileRelatedObjectsTask.this.log.debug("deleting sys log item " + sli.getUid());
                    AssetsStorage.get().delete((BaseAsset)sli);
                }
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALLIAS);
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                ArrayList<Projection> result = new ArrayList<Projection>();
                result.add(Projection.property((String)"containerUid", (String)UID_ALLIAS));
                return result;
            }

            @Override
            public String getThreadPrefix() {
                return "archive";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                return ((DeleteBookingFileRelatedObjectsTaskConfiguration)DeleteBookingFileRelatedObjectsTask.this.config).getCriterions();
            }
        };
    }
}

