/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cleanup;

import com.gridnine.xtrip.common.model.system.DeleteVersionsTaskConfiguration;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.cleanup.DeleteVersionsTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import java.util.Properties;

public class DeleteVersionsScheduledTask
extends BaseScheduledTask {
    public static final String SETTINGS_INCLUDE_KEY = "INCLUDE_CODES";
    public static final String THREADS_COUNT = "THREADS_COUNT";
    private String includeKeys;
    private int threadsCount;

    protected void configure(Properties properties) throws Exception {
        super.configure(properties);
        this.includeKeys = properties.getProperty(SETTINGS_INCLUDE_KEY);
        String threadsCountValue = properties.getProperty(THREADS_COUNT);
        this.threadsCount = TextUtil.isBlank((String)threadsCountValue) ? 1 : Integer.parseInt(threadsCountValue);
    }

    protected void doJob() throws Exception {
        DeleteVersionsTask task = new DeleteVersionsTask();
        DeleteVersionsTaskConfiguration config = new DeleteVersionsTaskConfiguration();
        config.setIncludeCodes(this.includeKeys);
        config.setThreadsCount(this.threadsCount);
        task.configure(config);
        task.doJob(new LongRunningTask.EventsCallback(){

            @Override
            public void updateProgress(byte progress) {
                DeleteVersionsScheduledTask.this.log.info(String.format("progress updated " + progress, new Object[0]));
            }

            @Override
            public void taskFinished() {
                DeleteVersionsScheduledTask.this.log.info("task finished");
            }

            @Override
            public void addEvent(String eventId, Message description) {
                switch (description.getType()) {
                    case MESSAGE: {
                        DeleteVersionsScheduledTask.this.log.debug(this.format(description));
                        return;
                    }
                    case WARNING: {
                        DeleteVersionsScheduledTask.this.log.warn(this.format(description));
                        return;
                    }
                    case ERROR: {
                        DeleteVersionsScheduledTask.this.log.error(this.format(description));
                        return;
                    }
                }
            }

            private String format(Message description) {
                if (TextUtil.isBlank((String)description.getDetails())) {
                    return description.getMessage().toString();
                }
                return String.format("%s, details:\n%s", description.getMessage().toString(), description.getDetails());
            }
        });
    }
}

