/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cn;

import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumber;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"category", "agencyUid", "contractUid", "startDate", "endDate"})})
public class ConsecutiveNumberData
extends BaseAssetData<ConsecutiveNumber> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ConsecutiveNumberData_modified")
    private Date modified;
    @Enumerated(value=EnumType.STRING)
    @Index(name="ConsecutiveNumberData_modified")
    @Column(nullable=false)
    private ConsecutiveNumberCategory category;
    @Index(name="ConsecutiveNumberData_number")
    @Column(nullable=false)
    private long number;
    @Index(name="ConsecutiveNumberData_agencyUid")
    @Column
    private String agencyUid;
    @Index(name="ConsecutiveNumberData_contractUid")
    @Column
    private String contractUid;
    @Index(name="ConsecutiveNumberData_cashUid")
    @Column
    private String cashUid;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ConsecutiveNumberData_startDate")
    @Column
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ConsecutiveNumberData_endDate")
    @Column
    private Date endDate;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(ConsecutiveNumber asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.category = asset.getCategory();
        this.number = asset.getNumber();
        this.agencyUid = asset.getAgencyUid();
        this.contractUid = asset.getContractUid();
        this.cashUid = asset.getCashUid();
        this.startDate = asset.getStartDate();
        this.endDate = asset.getEndDate();
    }

    public ConsecutiveNumber toAsset(Set<String> preferredProperties) throws Exception {
        ConsecutiveNumber result = new ConsecutiveNumber();
        result.setUid(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("category")) {
            result.setCategory(this.category);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("number")) {
            result.setNumber(this.number);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("agencyUid")) {
            result.setAgencyUid(this.agencyUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("contractUid")) {
            result.setContractUid(this.contractUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("cashUid")) {
            result.setCashUid(this.cashUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("startDate")) {
            result.setStartDate(this.startDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("endDate")) {
            result.setEndDate(this.endDate);
        }
        return result;
    }
}

