/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cn;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberPeriod;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberService;
import java.util.Date;

public class ConsecutiveNumberHelper {
    public static boolean isAgencyRequred(ConsecutiveNumberSerial serial) {
        return serial == ConsecutiveNumberSerial.AGENCY || serial == ConsecutiveNumberSerial.CONTRACT || serial == ConsecutiveNumberSerial.CASH;
    }

    public static boolean isContractRequred(ConsecutiveNumberSerial serial) {
        return serial == ConsecutiveNumberSerial.CONTRACT;
    }

    public static boolean isCashRequred(ConsecutiveNumberSerial serial) {
        return serial == ConsecutiveNumberSerial.CASH;
    }

    public static boolean isDateRequred(ConsecutiveNumberPeriod period) {
        return period == ConsecutiveNumberPeriod.YEAR || period == ConsecutiveNumberPeriod.MONTH;
    }

    public static Date getStartDate(ConsecutiveNumberPeriod period, Date date) {
        if (date != null) {
            if (period == ConsecutiveNumberPeriod.YEAR) {
                return MiscUtil.getYearBegin((Date)date);
            }
            if (period == ConsecutiveNumberPeriod.MONTH) {
                return MiscUtil.getMonthBegin((Date)date);
            }
        }
        return null;
    }

    public static Date getEndDate(ConsecutiveNumberPeriod period, Date date) {
        if (date != null) {
            if (period == ConsecutiveNumberPeriod.YEAR) {
                return MiscUtil.getYearEnd((Date)date);
            }
            if (period == ConsecutiveNumberPeriod.MONTH) {
                return MiscUtil.getMonthEnd((Date)date);
            }
        }
        return null;
    }

    public static long getNumber(ConsecutiveNumberHandler handler) throws Exception {
        ConsecutiveNumberSerial serial = handler.getSerial();
        ConsecutiveNumberPeriod period = handler.getPeriod();
        boolean agencyRequred = ConsecutiveNumberHelper.isAgencyRequred(serial);
        boolean contractRequred = ConsecutiveNumberHelper.isContractRequred(serial);
        boolean cashRequred = ConsecutiveNumberHelper.isCashRequred(serial);
        boolean dateRequred = ConsecutiveNumberHelper.isDateRequred(period);
        ConsecutiveNumberCategory category = handler.getCategory();
        EntityReference<Organization> agency = null;
        EntityReference<Contract> contract = null;
        EntityReference<Cash> cash = null;
        Date startDate = null;
        Date endDate = null;
        if (category == null) {
            throw new IllegalStateException("category is null");
        }
        if (agencyRequred && (agency = handler.getAgency()) == null) {
            throw new IllegalStateException("agency is null");
        }
        if (contractRequred && (contract = handler.getContract()) == null) {
            throw new IllegalStateException("contract is null");
        }
        if (cashRequred && (cash = handler.getCash()) == null) {
            throw new IllegalStateException("cash is null");
        }
        if (dateRequred) {
            Date date = handler.getDate();
            if (date == null) {
                throw new IllegalStateException("date is null");
            }
            startDate = ConsecutiveNumberHelper.getStartDate(period, date);
            endDate = ConsecutiveNumberHelper.getEndDate(period, date);
        }
        return ConsecutiveNumberService.get().getNumber(category, agency, contract, cash, startDate, endDate);
    }

    public static long incrementAndGetNumber(ConsecutiveNumberHandler handler) throws Exception {
        ConsecutiveNumberSerial serial = handler.getSerial();
        ConsecutiveNumberPeriod period = handler.getPeriod();
        boolean agencyRequred = ConsecutiveNumberHelper.isAgencyRequred(serial);
        boolean contractRequred = ConsecutiveNumberHelper.isContractRequred(serial);
        boolean cashRequred = ConsecutiveNumberHelper.isCashRequred(serial);
        boolean dateRequred = ConsecutiveNumberHelper.isDateRequred(period);
        ConsecutiveNumberCategory category = handler.getCategory();
        EntityReference<Organization> agency = null;
        EntityReference<Contract> contract = null;
        EntityReference<Cash> cash = null;
        Date startDate = null;
        Date endDate = null;
        if (category == null) {
            throw new IllegalStateException("category is null");
        }
        if (agencyRequred && (agency = handler.getAgency()) == null) {
            throw new IllegalStateException("agency is null");
        }
        if (contractRequred && (contract = handler.getContract()) == null) {
            throw new IllegalStateException("contract is null");
        }
        if (cashRequred && (cash = handler.getCash()) == null) {
            throw new IllegalStateException("cash is null");
        }
        if (dateRequred) {
            Date date = handler.getDate();
            if (date == null) {
                throw new IllegalStateException("date is null");
            }
            startDate = ConsecutiveNumberHelper.getStartDate(period, date);
            endDate = ConsecutiveNumberHelper.getEndDate(period, date);
        }
        return ConsecutiveNumberService.get().incrementAndGetNumber(category, agency, contract, cash, startDate, endDate);
    }

    public static interface ConsecutiveNumberHandler {
        public static ConsecutiveNumberHandler of(final ConsecutiveNumberCategory category) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }
            };
        }

        public static ConsecutiveNumberHandler of(final ConsecutiveNumberCategory category, final ConsecutiveNumberPeriod period, final Date date) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberPeriod getPeriod() {
                    return period;
                }

                @Override
                public Date getDate() {
                    return date;
                }
            };
        }

        public static ConsecutiveNumberHandler ofAgency(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.AGENCY;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }
            };
        }

        public static ConsecutiveNumberHandler ofAgency(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final ConsecutiveNumberPeriod period, final Date date) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.AGENCY;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }

                @Override
                public ConsecutiveNumberPeriod getPeriod() {
                    return period;
                }

                @Override
                public Date getDate() {
                    return date;
                }
            };
        }

        public static ConsecutiveNumberHandler ofContract(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final EntityReference<Contract> contract) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.CONTRACT;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }

                @Override
                public EntityReference<Contract> getContract() {
                    return contract;
                }
            };
        }

        public static ConsecutiveNumberHandler ofContract(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final EntityReference<Contract> contract, final ConsecutiveNumberPeriod period, final Date date) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.CONTRACT;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }

                @Override
                public EntityReference<Contract> getContract() {
                    return contract;
                }

                @Override
                public ConsecutiveNumberPeriod getPeriod() {
                    return period;
                }

                @Override
                public Date getDate() {
                    return date;
                }
            };
        }

        public static ConsecutiveNumberHandler ofCash(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final EntityReference<Cash> cash) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.CASH;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }

                @Override
                public EntityReference<Cash> getCash() {
                    return cash;
                }
            };
        }

        public static ConsecutiveNumberHandler ofCash(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final EntityReference<Cash> cash, final ConsecutiveNumberPeriod period, final Date date) {
            return new ConsecutiveNumberHandler(){

                @Override
                public ConsecutiveNumberCategory getCategory() {
                    return category;
                }

                @Override
                public ConsecutiveNumberSerial getSerial() {
                    return ConsecutiveNumberSerial.CASH;
                }

                @Override
                public EntityReference<Organization> getAgency() {
                    return agency;
                }

                @Override
                public EntityReference<Cash> getCash() {
                    return cash;
                }

                @Override
                public ConsecutiveNumberPeriod getPeriod() {
                    return period;
                }

                @Override
                public Date getDate() {
                    return date;
                }
            };
        }

        public ConsecutiveNumberCategory getCategory();

        default public ConsecutiveNumberSerial getSerial() {
            return null;
        }

        default public ConsecutiveNumberPeriod getPeriod() {
            return null;
        }

        default public EntityReference<Organization> getAgency() {
            return null;
        }

        default public EntityReference<Contract> getContract() {
            return null;
        }

        default public EntityReference<Cash> getCash() {
            return null;
        }

        default public Date getDate() {
            return null;
        }
    }
}

