/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.cn;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumber;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConsecutiveNumberService
implements ConsecutiveNumberService {
    private static final Logger log = LoggerFactory.getLogger(ConsecutiveNumberService.class);
    private static final String LOCK_NAME = "CN_LOCK_%s";
    private final AssetStorageManager storage = new AssetStorageManager();

    /*
     * Loose catch block
     */
    @Override
    public long getNumber(ConsecutiveNumberCategory category, EntityReference<Organization> agency, EntityReference<Contract> contract, EntityReference<Cash> cash, Date startDate, Date endDate) throws Exception {
        String id = this.buildId(category, agency, contract, cash, startDate, endDate);
        if (log.isDebugEnabled()) {
            log.debug("get number for " + id);
        }
        Throwable throwable = null;
        try (NamedLock lock = LockUtil.getLockManager().getLock((Object)String.format(LOCK_NAME, id));){
            block21: {
                if (!lock.tryLock(30L, TimeUnit.SECONDS)) break block21;
                ConsecutiveNumber asset = this.storage.load(category, agency, contract, cash, startDate, endDate);
                long l = asset.getNumber();
                {
                    catch (Throwable throwable2) {
                        try {
                            lock.unlock();
                        }
                        catch (Throwable t) {
                            log.error("failed unlock named lock " + t.getMessage(), t);
                        }
                        throw throwable2;
                    }
                }
                try {
                    lock.unlock();
                }
                catch (Throwable t) {
                    log.error("failed unlock named lock " + t.getMessage(), t);
                }
                return l;
            }
            try {
                throw new TimeoutException("failed to acquire named lock (timeout)");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long incrementAndGetNumber(ConsecutiveNumberCategory category, EntityReference<Organization> agency, EntityReference<Contract> contract, EntityReference<Cash> cash, Date startDate, Date endDate) throws Exception {
        String id = this.buildId(category, agency, contract, cash, startDate, endDate);
        if (log.isDebugEnabled()) {
            log.debug("increment and get number for " + id);
        }
        Throwable throwable = null;
        try (NamedLock lock = LockUtil.getLockManager().getLock((Object)String.format(LOCK_NAME, id));){
            block21: {
                if (!lock.tryLock(30L, TimeUnit.SECONDS)) break block21;
                ConsecutiveNumber asset = this.storage.load(category, agency, contract, cash, startDate, endDate);
                asset.setNumber(asset.getNumber() + 1L);
                this.storage.save(asset);
                long l = asset.getNumber();
                {
                    catch (Throwable throwable2) {
                        try {
                            lock.unlock();
                        }
                        catch (Throwable t) {
                            log.error("failed unlock named lock " + t.getMessage(), t);
                        }
                        throw throwable2;
                    }
                }
                try {
                    lock.unlock();
                }
                catch (Throwable t) {
                    log.error("failed unlock named lock " + t.getMessage(), t);
                }
                return l;
            }
            try {
                throw new TimeoutException("failed to acquire named lock (timeout)");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private String buildId(ConsecutiveNumberCategory category, EntityReference<Organization> agency, EntityReference<Contract> contract, EntityReference<Cash> cash, Date startDate, Date endDate) {
        return String.format("%s_%s_%s_%s_%s_%s", category != null ? category.name() : "", agency != null ? agency.getUid() : "", contract != null ? contract.getUid() : "", cash != null ? cash.getUid() : "", startDate != null ? startDate.toString() : "", endDate != null ? endDate.toString() : "");
    }

    public void dispose() {
        this.storage.dispose();
    }

    private static class AssetStorageManager {
        private final ExtendedProperties config = ServerConfiguration.get().getConfiguration();
        private final ExecutorServiceFacade worker = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("consecutive-number-service", 1);

        AssetStorageManager() throws GeneralSecurityException, IOException {
        }

        ConsecutiveNumber load(final ConsecutiveNumberCategory category, final EntityReference<Organization> agency, final EntityReference<Contract> contract, final EntityReference<Cash> cash, final Date startDate, final Date endDate) throws Exception {
            return (ConsecutiveNumber)((Object)this.worker.submit((Callable)new Callable<ConsecutiveNumber>(){

                @Override
                public ConsecutiveNumber call() throws Exception {
                    this.authorize();
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.category.name(), (Object)category));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.agencyUid.name(), agency != null ? agency.getUid() : null));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.contractUid.name(), contract != null ? contract.getUid() : null));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.cashUid.name(), cash != null ? cash.getUid() : null));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.startDate.name(), (Object)startDate));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ConsecutiveNumber.Property.endDate.name(), (Object)endDate));
                    List data = AssetsStorage.get().search(ConsecutiveNumber.class, query).getData();
                    if (data.size() != 0) {
                        return (ConsecutiveNumber)((Object)data.get(0));
                    }
                    ConsecutiveNumber asset = new ConsecutiveNumber();
                    asset.setCategory(category);
                    asset.setNumber(0L);
                    asset.setAgencyUid(agency != null ? agency.getUid() : null);
                    asset.setContractUid(contract != null ? contract.getUid() : null);
                    asset.setStartDate(startDate);
                    asset.setEndDate(endDate);
                    return asset;
                }
            }).get());
        }

        public void save(final ConsecutiveNumber asset) throws Exception {
            this.worker.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    this.authorize();
                    AssetsStorage.get().save((BaseAsset)asset);
                    return null;
                }
            }).get();
        }

        void authorize() throws Exception {
            if (UserData.get().getCurrentUser() == null) {
                LogicalStorage.get().authorizeAsSystem((Properties)this.config);
            }
        }

        void dispose() {
            this.worker.dispose();
        }
    }
}

