/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.Repository;
import com.gridnine.xtrip.common.model.assets.SmartFolder;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AddWorkspaceFolderItemHandler
implements SetupUpdateHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Element elm) throws Exception {
        Element root;
        String id = XHelper.readString((Element)elm, (String)"@itemId");
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        String workspaceUid = XHelper.readString((Element)elm, (String)"@workspaceUid");
        if (TextUtil.isBlank((String)id)) {
            this.log.warn("item id is null, workspace update will be skipped");
            return;
        }
        if (TextUtil.isBlank((String)fileName)) {
            this.log.warn("fileName is null, workspace update will be skipped");
            return;
        }
        if (TextUtil.isBlank((String)workspaceUid)) {
            this.log.warn("workspaceUid is null, workspace update will be skipped");
            return;
        }
        URL url = new URL(String.format("file:///%s/setup/assets/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName));
        if (!IoUtil.isResourceExists((URL)url)) {
            this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
            return;
        }
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        root.getOwnerDocument().setDocumentURI(url.toExternalForm());
        Element folderElement = null;
        String repositoryId = null;
        block3: for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            if (!Workspace.class.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class")) || !workspaceUid.equals(XmlUtil.getValue((Element)objElm, (String)"uid"))) continue;
            for (Element repElm : XmlUtil.getElements((Element)objElm, (String)"repositories/item")) {
                for (Element folderElm : XmlUtil.getElements((Element)repElm, (String)"folders/item")) {
                    if (!id.equals(XHelper.readString((Element)folderElm, (String)"id"))) continue;
                    folderElement = folderElm;
                    repositoryId = XHelper.readString((Element)repElm, (String)"id");
                    break block3;
                }
            }
        }
        if (folderElement == null) {
            this.log.warn("unable to find element with id " + id);
            return;
        }
        for (Workspace ws : AssetsStorage.get().search(Workspace.class, new SearchQuery()).getData()) {
            for (Repository rep : ws.getRepositories()) {
                if (!rep.getId().equals(repositoryId)) continue;
                SmartFolder sf = new SmartFolder();
                sf.fromXML(folderElement);
                rep.getFolders().add(sf);
                AssetsStorage.get().save((BaseAsset)ws);
                this.log.info(String.format("folder %s was added to repository %s of workspace %s", sf.getId(), rep.getId(), ws.getUid()));
            }
        }
    }
}

