/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BasicExportSettingsIndex;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BookingXmlExportSettingsUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        SearchQuery query = new SearchQuery();
        List settings = EntityStorage.get().search(BasicExportSettingsIndex.class, query).getData().stream().map(BasicExportSettingsIndex::getSource).filter(Objects::nonNull).filter(item -> item.getType() != null && item.getType().getName().equals("com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings")).collect(Collectors.toList());
        List<String> names = Arrays.asList("code", "caption", "inn", "kpp");
        for (EntityReference settingsRef : settings) {
            try {
                boolean changed = false;
                EntityContainer settingsCtr = EntityStorage.get().resolve(settingsRef);
                if (settingsCtr == null || !(settingsCtr.getEntity() instanceof BookingXmlExportSettings)) continue;
                BookingXmlExportSettings bookingSettings = (BookingXmlExportSettings)settingsCtr.getEntity();
                ElementExportSettings productsSettings = bookingSettings.getRootExportSettings().getChildren().stream().filter(item -> "products".equals(item.getName())).findFirst().orElse(null);
                if (productsSettings != null) {
                    for (ElementExportSettings productSettings : productsSettings.getChildren()) {
                        ElementExportSettings supplierSettings = productSettings.getChildren().stream().filter(item -> "supplier".equals(item.getName())).findFirst().orElse(null);
                        if (supplierSettings == null) continue;
                        names.forEach(name -> this.addChildSettings(supplierSettings, (String)name));
                        changed = true;
                    }
                }
                if (!changed) continue;
                settingsCtr.getVersionInfo().setDataSource("BookingXmlExportSettingsUpdateHandler");
                EntityStorage.get().save(settingsCtr, true);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error(String.format("unable to update settings %s", settingsRef), (Throwable)e);
            }
        }
    }

    private void addChildSettings(ElementExportSettings settings, String name) {
        ElementExportSettings childSettings = settings.getChildren().stream().filter(item -> name.equals(item.getName())).findFirst().orElse(null);
        if (childSettings == null) {
            childSettings = new ElementExportSettings();
            childSettings.setName(name);
            settings.getChildren().add(childSettings);
        }
        if ("code".equals(name) || "caption".equals(name)) {
            childSettings.setExported(settings.isExported());
        }
    }
}

