/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BrandName;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Element;

public class BrandNameAirlineCodeUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        Collection brandNames = DictionaryCache.get().getAll(BrandName.class).values();
        for (BrandName brandName : brandNames) {
            Airline airline = (Airline)DictHelper.resolve((DictionaryReference)brandName.getAirline());
            if (airline == null) continue;
            Map codeVariants = airline.getCodeVariants();
            String airlineCode = (String)codeVariants.getOrDefault(CodeSystem.IATA.name(), codeVariants.get(CodeSystem.CRT.name()));
            brandName.setAirlineCode(airlineCode);
            brandName.setAirline(null);
            brandName.setDataSource("BrandNameAirlineCodeUpdateHandler");
            DictionaryStorage.get().save((BaseDictionary)brandName);
        }
    }
}

