/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CurrencyRateSynchronizationSettingsMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        Logger log = LoggerFactory.getLogger(this.getClass());
        List allSettings = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, new SearchQuery()).getData();
        ScheduledTaskSettings scheduledTaskSettings = allSettings.stream().map(ref -> (ScheduledTaskSettings)EntityStorage.get().resolve(ref.getSource()).getEntity()).filter(setting -> "com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationTask".equalsIgnoreCase(setting.getJobClass())).findFirst().orElse(null);
        if (scheduledTaskSettings == null) {
            log.debug("No currency rate synchronization settings present");
            return;
        }
        log.debug("currency rate synchronization settings migration started");
        NamedValue url = new NamedValue();
        url.setName("currencySynchronizationUrl");
        url.setValue(((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration().getProperty("synchronization.url"));
        scheduledTaskSettings.getDataMap().add(url);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)scheduledTaskSettings), true);
        File file = new File(Environment.getConfigurationFolder(), "boot.properties");
        if (file.exists()) {
            List result = FileUtils.readLines((File)file);
            result = result.stream().filter(entry -> {
                boolean isToBeExcluded = entry.contains("com.gridnine.xtrip.server.synchronization.url") || entry.contains("com.gridnine.xtrip.server.synchronization.user") || entry.contains("com.gridnine.xtrip.server.synchronization.password");
                return !isToBeExcluded || entry.startsWith("#");
            }).collect(Collectors.toList());
            FileUtils.writeLines((File)file, result);
        }
        log.debug("currency rate synchronization settings migration finished");
    }
}

