/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CurrencyRateSynchronizationSettingsUrlUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        Logger log = LoggerFactory.getLogger(this.getClass());
        List allSettings = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, new SearchQuery()).getData();
        EntityContainer taskContainer = allSettings.stream().map(ref -> EntityStorage.get().resolve(ref.getSource())).filter(setting -> "com.gridnine.xtrip.server.model.synchronization.standard.CurrencyRateSynchronizationTask".equalsIgnoreCase(((ScheduledTaskSettings)setting.getEntity()).getJobClass())).findFirst().orElse(null);
        if (taskContainer == null) {
            log.warn("No currency rate synchronization settings present");
            return;
        }
        log.info("currency rate synchronization settings currencySynchronizationUrl update started");
        NamedValue synchEntry = ((ScheduledTaskSettings)taskContainer.getEntity()).getDataMap().stream().filter(data -> "currencySynchronizationUrl".equals(data.getName())).findFirst().orElse(null);
        if (synchEntry == null) {
            synchEntry = new NamedValue();
            synchEntry.setName("currencySynchronizationUrl");
            ((ScheduledTaskSettings)taskContainer.getEntity()).getDataMap().add(synchEntry);
        }
        synchEntry.setValue("http://ibe.gridnine.com:9090/sync/");
        taskContainer.getVersionInfo().setDataSource("common-data-update-46");
        EntityStorage.get().save(taskContainer, true);
        log.debug("currency rate synchronization settings currencySynchronizationUrl update finished");
    }
}

