/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Element;

public class DVFODictionaryUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        DictionaryReference<GeoRegion> dvfoRef = this.checkDVFORegion();
        Set<String> codes = this.getDVFOLocationsCrtCodes();
        for (String code : codes) {
            Set locations = DictionaryCache.get().lookup(GeoLocation.class, code, new String[]{CodeSystem.CRT.name()});
            for (GeoLocation loc : locations) {
                GeoLocation parent;
                if (loc.getType() == LocationType.AIRPORT && (parent = (GeoLocation)DictionaryCache.get().resolveReference(loc.getParent())) != null && codes.contains(parent.getCodeVariants().get(CodeSystem.CRT.name())) || loc.getRegions().contains(dvfoRef) || this.hasCycle(loc)) continue;
                loc.getRegions().add(dvfoRef);
                loc.setDataSource("DVFODictionaryUpdateHandler");
                DictionaryStorage.get().save((BaseDictionary)loc);
            }
        }
    }

    private boolean hasCycle(GeoLocation geoLocation) {
        LinkedHashSet<Object> visited = new LinkedHashSet<Object>();
        visited.add(geoLocation.toReference());
        DictionaryReference parent = geoLocation.getParent();
        while (parent != null) {
            if (!visited.add(parent)) {
                return true;
            }
            GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(parent);
            parent = loc == null ? null : loc.getParent();
        }
        return false;
    }

    public Set<String> getDVFOLocationsCrtCodes() throws IOException {
        HashSet<String> result = new HashSet<String>();
        try (InputStream is = this.getClass().getResourceAsStream("DVFOCodes.xlsx");){
            XSSFWorkbook wb = new XSSFWorkbook(is);
            Iterator rowIt = wb.getSheetAt(0).rowIterator();
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                if (row.getRowNum() < 1) continue;
                Cell cell = row.getCell(0);
                if (cell != null) {
                    result.add(cell.getRichStringCellValue().getString());
                }
                if ((cell = row.getCell(5)) == null) continue;
                result.add(cell.getRichStringCellValue().getString());
            }
        }
        return result;
    }

    private DictionaryReference<GeoRegion> checkDVFORegion() throws Exception {
        GeoRegion result = (GeoRegion)DictionaryCache.get().resolveReference((DictionaryReference)new GeoRegionReference("DVFO"));
        if (result != null) {
            return result.toReference();
        }
        result = new GeoRegion();
        result.setCode("DVFO");
        result.setUid("DVFO");
        result.getCodeVariants().put(CodeSystem.IATA.name(), "DVFO");
        result.getCodeVariants().put(CodeSystem.CRT.name(), "\u0414\u0412\u0424\u041e");
        result.getTranslations().put(LocaleHelper.RU_LOCALE, "\u0414\u0430\u043b\u044c\u043d\u0435\u0432\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0444\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433");
        result.getTranslations().put(LocaleHelper.EN_LOCALE, "Far Eastern Federal District");
        result.setDataSource("DVFODictionaryUpdateHandler");
        DictionaryStorage.get().save((BaseDictionary)result, false);
        return result.toReference();
    }
}

