/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsSettings;
import com.gridnine.xtrip.common.model.system.BalancesCachingSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ObjectCreationSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.licence.service.LicenceCheckerTask;
import com.gridnine.xtrip.server.licence.service.MetadataSenderTask;
import com.gridnine.xtrip.server.model.index.UpdateOrganizationBalanceTask;
import com.gridnine.xtrip.server.model.index.UpdatePersonBalanceTask;
import com.gridnine.xtrip.server.model.tasks.standard.IbusPollingConsumersLaunchTask;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;

public class DeleteObsoleteSystemSettingsHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        this.deleteBalanceCachingSettings();
        this.deleteFinanceDocumentsSettings();
        this.deleteObjectCreationSettings();
        this.deleteObsoleteTasks(MetadataSenderTask.class.getName(), LicenceCheckerTask.class.getName(), UpdatePersonBalanceTask.class.getName(), UpdateOrganizationBalanceTask.class.getName(), "com.gridnine.xtrip.server.model.RecalculateCombsTask");
        this.deleteEmptyPollingConsumersTask();
        this.deleteIrrelevantPayment1CSettings();
    }

    private void deleteIrrelevantPayment1CSettings() throws ClassNotFoundException {
        EntityContainer ctr = EntityStorage.get().load(XSHelper.getClass((String)"com.gridnine.xtrip.common.parsers.model.StandardExchangeDocumentParserSettings"), "com.gridnine.xtrip.common.parsers.model.StandardExchangeDocumentParserSettings-PAYMENT-1C");
        if (ctr != null) {
            EntityStorage.get().delete(ctr);
        }
        if ((ctr = EntityStorage.get().load(ScheduledTaskSettings.class, "payment-1c-scheduled-task-settings")) != null) {
            EntityStorage.get().delete(ctr);
        }
    }

    private void deleteEmptyPollingConsumersTask() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        List ctrs = StorageHelper.getEntityContainers((SearchQuery)query, BasicSystemSettingsIndex.class);
        for (EntityContainer ctr : ctrs) {
            if (!(ctr.getEntity() instanceof ScheduledTaskSettings)) continue;
            ScheduledTaskSettings ts = (ScheduledTaskSettings)ctr.getEntity();
            if (!IbusPollingConsumersLaunchTask.class.getName().equals(ts.getJobClass())) continue;
            boolean found = false;
            for (NamedValue nv : ts.getDataMap()) {
                if (!"consumers".equals(nv.getName()) || TextUtil.isBlank((String)nv.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            EntityStorage.get().delete(ctr);
        }
    }

    private void deleteObsoleteTasks(String ... classes) {
        HashSet<String> classNames = new HashSet<String>();
        for (String clsName : classes) {
            classNames.add(clsName);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        List ctrs = StorageHelper.getEntityContainers((SearchQuery)query, BasicSystemSettingsIndex.class);
        for (EntityContainer ctr : ctrs) {
            ScheduledTaskSettings ts;
            if (!(ctr.getEntity() instanceof ScheduledTaskSettings) || !classNames.contains((ts = (ScheduledTaskSettings)ctr.getEntity()).getJobClass())) continue;
            EntityStorage.get().delete(ctr);
        }
    }

    private void deleteObjectCreationSettings() {
        EntityContainer ctr = EntityStorage.get().load(ObjectCreationSettings.class, "OBJECT_CREATION_SETTINGS_UID");
        if (ctr != null) {
            EntityStorage.get().delete(ctr);
        }
    }

    private void deleteFinanceDocumentsSettings() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)FinanceDocumentsSettings.class.getName()));
        for (EntityContainer item : StorageHelper.getEntityContainers((SearchQuery)query, BasicSystemSettingsIndex.class)) {
            EntityStorage.get().delete(item);
        }
    }

    private void deleteBalanceCachingSettings() {
        EntityContainer ctr = EntityStorage.get().load(BalancesCachingSettings.class, "BALANCES_CACHING_SETTINGS");
        if (ctr != null) {
            EntityStorage.get().delete(ctr);
        }
    }
}

