/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.db.update;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class GdsInterfaceSettingsUpdateHandler
implements SetupUpdateHandler {
    private static final List<String> MOM_BASIC_GDS_LIST = new ArrayList<String>(){
        {
            this.add("SABRE");
            this.add("SIRENA");
            this.add("GABRIEL");
            this.add("WEB_SITE");
            this.add("UFS");
            this.add("EXPRESS");
            this.add("TELETRAIN");
            this.add("INMOB");
            this.add("SPGD");
            this.add("HOTELBOOK");
            this.add("ALFASTRAH");
            this.add("RENAISSANCE");
        }
    };

    public void execute(Element command) throws Exception {
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.debug("GDS interface setting update");
        StringBuilder settings = new StringBuilder();
        for (GdsName gds : GdsName.values()) {
            if (!MOM_BASIC_GDS_LIST.contains(gds.name())) continue;
            settings.append((settings.length() > 0 ? "|" : "") + gds.name());
        }
        Map map = DictionaryCache.get().getAll(Preference.class);
        Preference gdsSettingsPreference = (Preference)map.get(PreferenceKey.GDS_CHOICE_SETTINGS.name());
        if (gdsSettingsPreference != null) {
            gdsSettingsPreference.setValue(settings.toString());
            if (gdsSettingsPreference.getKey() == null) {
                gdsSettingsPreference.setKey(PreferenceKey.GDS_CHOICE_SETTINGS);
            }
        } else {
            gdsSettingsPreference = new Preference();
            gdsSettingsPreference.setUid(UUIDGenerator.generate().toString());
            gdsSettingsPreference.setCode(PreferenceKey.GDS_CHOICE_SETTINGS.name());
            gdsSettingsPreference.setKey(PreferenceKey.GDS_CHOICE_SETTINGS);
            gdsSettingsPreference.setValue(settings.toString());
        }
        gdsSettingsPreference.setDataSource("GdsInterfaceSettingsUpdateHandler");
        DictionaryStorage.get().save((BaseDictionary)gdsSettingsPreference);
        log.debug("GDS interface setting update finished");
    }
}

